/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.ILogWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALFileVersion;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogWriter
implements ILogWriter {
    private static final Logger logger = LoggerFactory.getLogger(LogWriter.class);
    protected final File logFile;
    protected final FileOutputStream logStream;
    protected final FileChannel logChannel;
    protected long originalSize = 0L;
    private final int COMPRESSED_HEADER_SIZE = 9;
    private final int UN_COMPRESSED_HEADER_SIZE = 5;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(9);
    private ICompressor compressor = ICompressor.getCompressor((CompressionType)IoTDBDescriptor.getInstance().getConfig().getWALCompressionAlgorithm());
    private ByteBuffer compressedByteBuffer;
    private static long MIN_COMPRESSION_SIZE = 32768L;

    protected LogWriter(File logFile, WALFileVersion version) throws IOException {
        this.logFile = logFile;
        this.logStream = new FileOutputStream(logFile, true);
        this.logChannel = this.logStream.getChannel();
        if (!(logFile.exists() && logFile.length() != 0L || version != WALFileVersion.V2)) {
            this.logChannel.write(ByteBuffer.wrap(version.getVersionBytes()));
        }
    }

    @Override
    public double write(ByteBuffer buffer, boolean allowCompress) throws IOException {
        long startTime = System.nanoTime();
        CompressionType compressionType = allowCompress ? IoTDBDescriptor.getInstance().getConfig().getWALCompressionAlgorithm() : CompressionType.UNCOMPRESSED;
        int bufferSize = buffer.position();
        if (bufferSize == 0) {
            return 1.0;
        }
        this.originalSize += (long)bufferSize;
        buffer.flip();
        boolean compressed = false;
        int uncompressedSize = bufferSize;
        if (compressionType != CompressionType.UNCOMPRESSED && (long)bufferSize > MIN_COMPRESSION_SIZE && this.compressedByteBuffer != null) {
            this.compressedByteBuffer.clear();
            if (this.compressor.getType() != compressionType) {
                this.compressor = ICompressor.getCompressor((CompressionType)compressionType);
            }
            this.compressor.compress(buffer, this.compressedByteBuffer);
            buffer = this.compressedByteBuffer;
            bufferSize = buffer.position();
            buffer.flip();
            compressed = true;
        }
        this.headerBuffer.clear();
        this.headerBuffer.put(compressed ? compressionType.serialize() : CompressionType.UNCOMPRESSED.serialize());
        this.headerBuffer.putInt(bufferSize);
        if (compressed) {
            this.headerBuffer.putInt(uncompressedSize);
            WritingMetrics.getInstance().recordCompressWALBufferCost(System.nanoTime() - startTime);
        }
        startTime = System.nanoTime();
        try {
            this.headerBuffer.flip();
            this.logChannel.write(this.headerBuffer);
            this.logChannel.write(buffer);
        }
        catch (ClosedChannelException e) {
            logger.warn("Cannot write to {}", (Object)this.logFile, (Object)e);
        }
        WritingMetrics.getInstance().recordWroteWALBuffer(uncompressedSize, bufferSize, System.nanoTime() - startTime);
        return (double)bufferSize / (double)uncompressedSize;
    }

    @Override
    public double write(ByteBuffer buffer) throws IOException {
        return this.write(buffer, true);
    }

    @Override
    public void force() throws IOException {
        this.force(true);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (this.logChannel != null && this.logChannel.isOpen()) {
            this.logChannel.force(metaData);
        }
    }

    @Override
    public long size() {
        return this.logFile.length();
    }

    public long originalSize() {
        return this.originalSize;
    }

    @Override
    public File getLogFile() {
        return this.logFile;
    }

    @Override
    public void close() throws IOException {
        if (this.logChannel != null) {
            try {
                if (this.logChannel.isOpen()) {
                    this.logChannel.force(true);
                }
            }
            finally {
                this.logChannel.close();
                this.logStream.close();
            }
        }
    }

    public void setCompressedByteBuffer(ByteBuffer compressedByteBuffer) {
        this.compressedByteBuffer = compressedByteBuffer;
    }

    public long getOffset() throws IOException {
        return this.logChannel.position();
    }
}

