/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.stack;

import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.stack.PageLockStackSnapshot;

public class LockStack
extends PageLockTracker<PageLockStackSnapshot> {
    protected int headIdx;

    public LockStack(String name, PageMetaInfoStore pageMetaInfoStore, MemoryCalculator memCalc) {
        super(name, pageMetaInfoStore, memCalc);
    }

    @Override
    public void onWriteLock0(int structureId, long pageId, long page, long pageAddr) {
        this.push(3, structureId, pageId, page, pageAddr);
    }

    @Override
    public void onWriteUnlock0(int structureId, long pageId, long page, long pageAddr) {
        this.pop(4, structureId, pageId);
    }

    @Override
    public void onReadLock0(int structureId, long pageId, long page, long pageAddr) {
        this.push(1, structureId, pageId, page, pageAddr);
    }

    @Override
    public void onReadUnlock0(int structureId, long pageId, long page, long pageAddr) {
        this.pop(2, structureId, pageId);
    }

    private void push(int op, int structureId, long pageId, long pageAddrHeader, long pageAddr) {
        if (!this.validateOperation(structureId, pageId, op)) {
            return;
        }
        this.reset();
        if (this.headIdx + 1 > this.pages.capacity()) {
            this.invalid("Stack overflow, size=" + this.pages.capacity() + ", headIdx=" + this.headIdx + " " + LockStack.argsToString(structureId, pageId, op));
            return;
        }
        long pageId0 = this.pages.getPageId(this.headIdx);
        if (pageId0 != 0L) {
            this.invalid("Head element should be empty, headIdx=" + this.headIdx + ", pageIdOnHead=" + pageId0 + " " + LockStack.argsToString(structureId, pageId, op));
            return;
        }
        int curIdx = this.heldLockCnt << 16 & 0xFFFF0000;
        this.pages.add(this.headIdx, curIdx | op, structureId, pageId, pageAddrHeader, pageAddr);
        ++this.headIdx;
        ++this.heldLockCnt;
    }

    private void pop(int op, int structureId, long pageId) {
        if (!this.validateOperation(structureId, pageId, op)) {
            return;
        }
        this.reset();
        if (this.headIdx > 1) {
            int lastItemIdx = this.headIdx - 1;
            long lastPageId = this.pages.getPageId(lastItemIdx);
            if (lastPageId == pageId) {
                this.pages.remove(lastItemIdx);
                do {
                    --this.headIdx;
                    --this.heldLockCnt;
                } while (this.headIdx > 0 && this.pages.getPageId(this.headIdx - 1) == 0L);
            } else {
                for (int itemIdx = lastItemIdx - 1; itemIdx >= 0; --itemIdx) {
                    if (this.pages.getPageId(itemIdx) != pageId) continue;
                    this.pages.remove(itemIdx);
                    return;
                }
                this.invalid("Can not find pageId in stack, headIdx=" + this.headIdx + " " + LockStack.argsToString(structureId, pageId, op));
            }
        } else {
            if (this.headIdx < 0) {
                this.invalid("HeadIdx can not be less, headIdx=" + this.headIdx + ", " + LockStack.argsToString(structureId, pageId, op));
                return;
            }
            long pageId0 = this.pages.getPageId(0);
            if (pageId0 == 0L) {
                this.invalid("Stack is empty, can not pop elemnt" + LockStack.argsToString(structureId, pageId, op));
                return;
            }
            if (pageId0 == pageId) {
                this.pages.remove(0);
                this.headIdx = 0;
                this.heldLockCnt = 0;
            } else {
                this.invalid("Can not find pageId in stack, headIdx=" + this.headIdx + " " + LockStack.argsToString(structureId, pageId, op));
            }
        }
    }

    @Override
    protected PageLockStackSnapshot snapshot() {
        PageMetaInfoStore stack = this.pages.copy();
        return new PageLockStackSnapshot(this.name, System.currentTimeMillis(), this.headIdx, stack, this.nextOp, this.nextOpStructureId, this.nextOpPageId);
    }

    private void reset() {
        this.nextOpPageId = 0L;
        this.nextOp = 0;
        this.nextOpStructureId = 0;
    }
}

