/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.ignite3.configuration.ConfigurationValue;
import org.apache.ignite3.internal.configuration.ComponentWorkingDir;
import org.apache.ignite3.internal.configuration.SystemLocalConfiguration;

public class IgnitePaths {
    private static final Path PARTITIONS_BASE_PATH = Paths.get("partitions", new String[0]);
    private static final Path VAULT_DB_PATH = Paths.get("vault", new String[0]);
    private static final Path METASTORAGE_PATH = Paths.get("metastorage", new String[0]);
    private static final Path CMG_PATH = Paths.get("cmg", new String[0]);

    public static ComponentWorkingDir partitionsPath(final SystemLocalConfiguration systemConfiguration, Path workDir) {
        Path basePath = IgnitePaths.pathOrDefault(systemConfiguration.partitionsBasePath(), () -> workDir.resolve(PARTITIONS_BASE_PATH));
        return new ComponentWorkingDir(basePath){

            @Override
            public Path raftLogPath() {
                return IgnitePaths.pathOrDefault(systemConfiguration.partitionsLogPath(), () -> super.raftLogPath());
            }
        };
    }

    public static ComponentWorkingDir metastoragePath(SystemLocalConfiguration systemConfiguration, Path workDir) {
        Path basePath = IgnitePaths.pathOrDefault(systemConfiguration.metastoragePath(), () -> workDir.resolve(METASTORAGE_PATH));
        return new ComponentWorkingDir(basePath);
    }

    public static ComponentWorkingDir cmgPath(SystemLocalConfiguration systemConfiguration, Path workDir) {
        Path basePath = IgnitePaths.pathOrDefault(systemConfiguration.cmgPath(), () -> workDir.resolve(CMG_PATH));
        return new ComponentWorkingDir(basePath);
    }

    public static Path vaultPath(Path workDir) {
        return workDir.resolve(VAULT_DB_PATH);
    }

    private IgnitePaths() {
    }

    private static Path pathOrDefault(ConfigurationValue<String> value, Supplier<Path> defaultPathSupplier) {
        String valueStr = (String)value.value();
        return valueStr.isEmpty() ? defaultPathSupplier.get() : Path.of(valueStr, new String[0]);
    }
}

