/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.replicator;

import org.apache.ignite.internal.event.EventParameters;

/**
 * Parameters of events produced by {@link ReplicaManager}.
 */
public class LocalReplicaEventParameters implements EventParameters {
    /** ID of the created replica. */
    private final ReplicationGroupId groupId;

    /**
     * Constructor.
     *
     * @param groupId Replication Group ID.
     */
    public LocalReplicaEventParameters(ReplicationGroupId groupId) {
        this.groupId = groupId;
    }

    public ReplicationGroupId groupId() {
        return groupId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LocalReplicaEventParameters that = (LocalReplicaEventParameters) o;

        return groupId.equals(that.groupId);
    }

    @Override
    public int hashCode() {
        return groupId.hashCode();
    }
}
