/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.time;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.configuration.MetaStorageConfiguration;
import org.apache.ignite.internal.metastorage.metrics.MetaStorageMetrics;
import org.apache.ignite.internal.metastorage.server.time.ClusterTime;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.jetbrains.annotations.Nullable;

public class ClusterTimeImpl
implements ClusterTime,
MetaStorageMetrics,
ManuallyCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterTimeImpl.class);
    private final String nodeName;
    private final IgniteSpinBusyLock busyLock;
    private final HybridClock clock;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTime = new PendingComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE);
    @Nullable
    private SafeTimeScheduler safeTimeScheduler;

    @Override
    public long safeTimeLag() {
        return this.clock.now().getPhysical() - ((HybridTimestamp)this.safeTime.current()).getPhysical();
    }

    public ClusterTimeImpl(String nodeName, IgniteSpinBusyLock busyLock, HybridClock clock) {
        this.nodeName = nodeName;
        this.busyLock = busyLock;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSafeTimeScheduler(SyncTimeAction syncTimeAction, MetaStorageConfiguration configuration) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            ClusterTimeImpl clusterTimeImpl = this;
            synchronized (clusterTimeImpl) {
                assert (this.safeTimeScheduler == null);
                this.safeTimeScheduler = new SafeTimeScheduler(syncTimeAction, configuration);
                this.safeTimeScheduler.start();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public synchronized void stopSafeTimeScheduler() {
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.stop();
            this.safeTimeScheduler = null;
        }
    }

    public void close() throws Exception {
        this.stopSafeTimeScheduler();
        this.safeTime.close();
    }

    public HybridTimestamp currentSafeTime() {
        return (HybridTimestamp)this.safeTime.current();
    }

    public CompletableFuture<Void> waitFor(HybridTimestamp time) {
        return this.safeTime.waitFor((Comparable)time);
    }

    public void updateSafeTime(HybridTimestamp newValue) {
        this.safeTime.update((Comparable)newValue, null);
    }

    public synchronized void adjustClock(HybridTimestamp ts) {
        this.clock.update(ts);
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.schedule();
        }
    }

    private class SafeTimeScheduler {
        private final SyncTimeAction syncTimeAction;
        private final MetaStorageConfiguration configuration;
        private final ScheduledExecutorService executorService;
        @Nullable
        private ScheduledFuture<?> currentTask;

        SafeTimeScheduler(SyncTimeAction syncTimeAction, MetaStorageConfiguration configuration) {
            this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.create((String)ClusterTimeImpl.this.nodeName, (String)"meta-storage-safe-time", (IgniteLogger)LOG));
            this.syncTimeAction = syncTimeAction;
            this.configuration = configuration;
        }

        void start() {
            this.schedule();
        }

        synchronized void schedule() {
            if (this.currentTask != null) {
                this.currentTask.cancel(false);
            }
            this.currentTask = this.executorService.schedule(() -> {
                if (!ClusterTimeImpl.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    this.syncTimeAction.syncTime(ClusterTimeImpl.this.clock.now()).whenComplete((v, e) -> {
                        Throwable cause;
                        if (e != null && !((cause = ExceptionUtils.unwrapCause((Throwable)e)) instanceof CancellationException) && !(cause instanceof NodeStoppingException)) {
                            LOG.error("Unable to perform idle time sync", e);
                        }
                    });
                    this.schedule();
                }
                finally {
                    ClusterTimeImpl.this.busyLock.leaveBusy();
                }
            }, (long)((Long)this.configuration.idleSyncTimeInterval().value()), TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            SafeTimeScheduler safeTimeScheduler = this;
            synchronized (safeTimeScheduler) {
                if (this.currentTask != null) {
                    this.currentTask.cancel(false);
                }
            }
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @FunctionalInterface
    public static interface SyncTimeAction {
        public CompletableFuture<Void> syncTime(HybridTimestamp var1);
    }
}

