/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.reset;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.recovery.reset.ResetPartitionsCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ResetPartitionsRequest;

@Singleton
public class ResetPartitionsCall
implements Call<ResetPartitionsCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ResetPartitionsCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(ResetPartitionsCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        ResetPartitionsRequest command = new ResetPartitionsRequest();
        command.setPartitionIds(input.partitionIds());
        command.setTableName(input.tableName());
        command.setZoneName(input.zoneName());
        try {
            client.resetPartitions(command);
            return DefaultCallOutput.success("Successfully reset partitions.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

