/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.WaitMapExchangeFinishCallable;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutMultiCacheTxBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private IgniteTransactions txs;
    private Callable<Void> clo;
    private int cacheOperations;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (this.cachesCnt() <= 1) {
            throw new IllegalArgumentException("Please configure --cachesCnt param, need to be more that 1.");
        }
        if (!IgniteSystemProperties.getBoolean((String)"SKIP_MAP_CHECK")) {
            this.ignite().compute().broadcast((IgniteCallable)new WaitMapExchangeFinishCallable());
        }
        this.txs = this.ignite().transactions();
        this.cacheOperations = this.args.opsPerCache();
        for (IgniteCache cache : this.testCaches) {
            if (((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL) continue;
            throw new IllegalArgumentException("Only transactional caches need to be present.");
        }
        this.clo = () -> {
            int key = IgnitePutMultiCacheTxBenchmark.nextRandom(this.args.range());
            int shift = 0;
            for (int i = 0; i < this.cacheOperations; ++i) {
                for (IgniteCache cache : this.testCaches) {
                    cache.put((Object)key, (Object)new SampleValue(key + shift, UUID.randomUUID()));
                    ++shift;
                }
            }
            return null;
        };
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteBenchmarkUtils.doInTransaction(this.txs, this.args.txConcurrency(), this.args.txIsolation(), this.clo);
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }

    private static class SampleValue {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private UUID uid;

        private SampleValue() {
        }

        public SampleValue(int id, UUID uid) {
            this.id = id;
            this.uid = uid;
        }
    }
}

