/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class BooleanColumnStatsAggregator
extends ColumnStatsAggregator {
    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        BooleanColumnStatsData aggregateData = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
            }
            BooleanColumnStatsData newData = cso.getStatsData().getBooleanStats();
            if (aggregateData == null) {
                aggregateData = newData.deepCopy();
                continue;
            }
            aggregateData.setNumTrues(aggregateData.getNumTrues() + newData.getNumTrues());
            aggregateData.setNumFalses(aggregateData.getNumFalses() + newData.getNumFalses());
            aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        }
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        columnStatisticsData.setBooleanStats(aggregateData);
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }
}

