/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.requests.BrokerHeartbeatResponse;

public class BrokerHeartbeatRequest
extends AbstractRequest {
    private final BrokerHeartbeatRequestData data;

    public BrokerHeartbeatRequest(BrokerHeartbeatRequestData data, short version) {
        super(ApiKeys.BROKER_HEARTBEAT, version);
        this.data = data;
    }

    @Override
    public BrokerHeartbeatRequestData data() {
        return this.data;
    }

    @Override
    public BrokerHeartbeatResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static BrokerHeartbeatRequest parse(ByteBuffer buffer, short version) {
        return new BrokerHeartbeatRequest(new BrokerHeartbeatRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<BrokerHeartbeatRequest> {
        private final BrokerHeartbeatRequestData data;

        public Builder(BrokerHeartbeatRequestData data) {
            super(ApiKeys.BROKER_HEARTBEAT);
            this.data = data;
        }

        @Override
        public BrokerHeartbeatRequest build(short version) {
            return new BrokerHeartbeatRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

