/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.QualifierUtil;
import org.apache.derbyTesting.unitTests.store.T_SecondaryIndexRow;

public class T_QualifierTest {
    private String init_conglomerate_type;
    private Properties init_properties;
    private boolean init_temporary;
    private HeaderPrintWriter init_out;
    private int init_order = 3;
    public static final int ORDER_FORWARD = 1;
    public static final int ORDER_BACKWARD = 2;
    public static final int ORDER_NONE = 3;
    public static final int ORDER_DESC = 4;

    public T_QualifierTest(String string, Properties properties, boolean bl, HeaderPrintWriter headerPrintWriter, int n) {
        this.init_conglomerate_type = string;
        this.init_properties = properties;
        this.init_temporary = bl;
        this.init_out = headerPrintWriter;
        this.init_order = n;
    }

    private static HashSet<Long> create_hash_set(int n, int n2, int n3) {
        HashSet<Long> hashSet = new HashSet<Long>(10, 0.8f);
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            hashSet.add(Long.valueOf(n4));
            if (n3 == 4) {
                --n4;
                continue;
            }
            ++n4;
        }
        return hashSet;
    }

    private static int flip_scan_op(int n) {
        int n2 = -42;
        if (n == 1) {
            n2 = -1;
        } else if (n == -1) {
            n2 = 1;
        }
        return n2;
    }

    public static boolean t_scan(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, DataValueDescriptor[] dataValueDescriptorArray3, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray4, int n2, int n3, int n4, int n5) throws StandardException, T_Fail {
        boolean bl = T_QualifierTest.t_scanNext(transactionController, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchNext(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchNextPartial(transactionController, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchHashtable(transactionController, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchNextGroup(transactionController, 1, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchNextGroup(transactionController, 2, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        bl = T_QualifierTest.t_scanFetchNextGroup(transactionController, 1000, l, dataValueDescriptorArray2, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2, n3, n4, n5);
        if (!bl) {
            return bl;
        }
        return bl;
    }

    private static boolean t_scanNext(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray3, int n2, int n3, int n4, int n5) throws StandardException, T_Fail {
        HashSet<Long> hashSet = null;
        boolean bl = n5 == 1 || n5 == 4;
        int n6 = n4;
        if (!bl) {
            hashSet = T_QualifierTest.create_hash_set(n4, n3, n5);
        }
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, dataValueDescriptorArray2, n, qualifierArray, dataValueDescriptorArray3, n2);
        long l2 = -42L;
        int n7 = 0;
        while (scanController.next()) {
            scanController.fetch(dataValueDescriptorArray);
            l2 = ((SQLLongint)dataValueDescriptorArray[2]).getLong();
            if (bl) {
                if (l2 != (long)n6) {
                    return T_QualifierTest.fail("(t_scanNext) wrong key, expected (" + n6 + ")but got (" + l2 + ").");
                }
                n6 = n5 == 4 ? --n6 : ++n6;
            } else if (!hashSet.remove(l2)) {
                return T_QualifierTest.fail("(t_scanNext) wrong key, expected (" + n6 + ")but got (" + l2 + ").");
            }
            ++n7;
        }
        scanController.close();
        if (n7 != n3) {
            return T_QualifierTest.fail("(t_scanNext) wrong number of rows. Expected " + n3 + " rows, but got " + n7 + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNext(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, DataValueDescriptor[] dataValueDescriptorArray3, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray4, int n2, int n3, int n4, int n5) throws StandardException, T_Fail {
        boolean bl;
        HashSet<Long> hashSet = null;
        boolean bl2 = bl = n5 == 1 || n5 == 4;
        if (!bl) {
            hashSet = T_QualifierTest.create_hash_set(n4, n3, n5);
        }
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, (FormatableBitSet)null, dataValueDescriptorArray3, n, qualifierArray, dataValueDescriptorArray4, n2);
        int n6 = n4;
        long l2 = -42L;
        long l3 = 0L;
        while (scanController.fetchNext(dataValueDescriptorArray2)) {
            scanController.fetch(dataValueDescriptorArray);
            for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
                if (dataValueDescriptorArray2[i].compare(dataValueDescriptorArray[i]) == 0) continue;
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + dataValueDescriptorArray2[i] + ")but got (" + dataValueDescriptorArray[i] + ").");
            }
            l2 = ((SQLLongint)dataValueDescriptorArray[2]).getLong();
            if (bl) {
                if (l2 != (long)n6) {
                    return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + n6 + ")but got (" + l2 + ").");
                }
                n6 = n5 == 4 ? --n6 : ++n6;
            } else if (!hashSet.remove(l2)) {
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + n6 + ")but got (" + l2 + ").");
            }
            ++l3;
        }
        scanController.close();
        if (l3 != (long)n3) {
            return T_QualifierTest.fail("(t_scanFetchNext) wrong number of rows. Expected " + n3 + " rows, but got " + l3 + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNextGroup(TransactionController transactionController, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray3, int n3, int n4, int n5, int n6) throws StandardException, T_Fail {
        boolean bl;
        HashSet<Long> hashSet = null;
        boolean bl2 = bl = n6 == 1 || n6 == 4;
        if (!bl) {
            hashSet = T_QualifierTest.create_hash_set(n5, n4, n6);
        }
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(l, false, 0, 6, 5, (FormatableBitSet)null, dataValueDescriptorArray2, n2, qualifierArray, dataValueDescriptorArray3, n3);
        DataValueDescriptor[][] dataValueDescriptorArrayArray = new DataValueDescriptor[n][];
        dataValueDescriptorArrayArray[0] = TemplateRow.newRow((DataValueDescriptor[])dataValueDescriptorArray);
        int n7 = n5;
        long l2 = -42L;
        long l3 = 0L;
        int n8 = 0;
        while ((n8 = groupFetchScanController.fetchNextGroup((DataValueDescriptor[][])dataValueDescriptorArrayArray, (RowLocation[])null)) != 0) {
            for (int i = 0; i < n8; ++i) {
                l2 = ((SQLLongint)dataValueDescriptorArrayArray[i][2]).getLong();
                if (bl) {
                    if (l2 != (long)n7) {
                        return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong key, expect (" + n7 + ")but got (" + l2 + "). num rows = " + l3);
                    }
                    n7 = n6 == 4 ? --n7 : ++n7;
                } else if (!hashSet.remove(l2)) {
                    return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong key, expected (" + n7 + ")but got (" + l2 + ").");
                }
                ++l3;
            }
        }
        groupFetchScanController.close();
        if (l3 != (long)n4) {
            return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong number of rows. Expected " + n4 + " rows, but got " + l3 + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNextPartial(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray3, int n2, int n3, int n4, int n5) throws StandardException, T_Fail {
        int n6;
        HashSet<Long> hashSet = null;
        boolean bl = n5 == 1 || n5 == 4;
        FormatableBitSet formatableBitSet = RowUtil.getQualifierBitSet((Qualifier[][])qualifierArray);
        formatableBitSet.grow(3);
        formatableBitSet.set(2);
        if (dataValueDescriptorArray2 != null) {
            for (n6 = 0; n6 < dataValueDescriptorArray2.length; ++n6) {
                formatableBitSet.set(n6);
            }
        }
        if (dataValueDescriptorArray3 != null) {
            for (n6 = 0; n6 < dataValueDescriptorArray3.length; ++n6) {
                formatableBitSet.set(n6);
            }
        }
        SQLLongint sQLLongint = (SQLLongint)dataValueDescriptorArray[2];
        if (!bl) {
            hashSet = T_QualifierTest.create_hash_set(n4, n3, n5);
        }
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 5, formatableBitSet, dataValueDescriptorArray2, n, qualifierArray, dataValueDescriptorArray3, n2);
        int n7 = n4;
        long l2 = -42L;
        long l3 = -42L;
        long l4 = 0L;
        while (scanController.fetchNext(dataValueDescriptorArray)) {
            l2 = sQLLongint.getLong();
            sQLLongint.setValue(-42);
            scanController.fetch(dataValueDescriptorArray);
            l3 = sQLLongint.getLong();
            if (bl) {
                if (l2 != (long)n7 || l3 != (long)n7) {
                    return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + n7 + ")but got (" + l2 + ").");
                }
                n7 = n5 == 4 ? --n7 : ++n7;
            } else if (!hashSet.remove(l2)) {
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + n7 + ")but got (" + l2 + ").");
            }
            ++l4;
        }
        scanController.close();
        if (l4 != (long)n3) {
            return T_QualifierTest.fail("(t_scanFetchNext) wrong number of rows. Expected " + n3 + " rows, but got " + l4 + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchHashtable(TransactionController transactionController, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray3, int n2, int n3, int n4, int n5) throws StandardException, T_Fail {
        Object object;
        HashSet<Long> hashSet = null;
        long l2 = 0L;
        boolean bl = n5 == 1 || n5 == 4;
        hashSet = T_QualifierTest.create_hash_set(n4, n3, n5);
        int[] nArray = new int[]{0};
        BackingStoreHashtable backingStoreHashtable = transactionController.createBackingStoreHashtableFromScan(l, 0, 7, 5, (FormatableBitSet)null, dataValueDescriptorArray2, n, qualifierArray, dataValueDescriptorArray3, n2, -1L, nArray, false, -1L, -1L, -1, -1.0f, false, false, false, false);
        Enumeration enumeration = backingStoreHashtable.elements();
        while (enumeration.hasMoreElements()) {
            long l3;
            DataValueDescriptor[] dataValueDescriptorArray4 = null;
            object = enumeration.nextElement();
            if (object instanceof DataValueDescriptor[]) {
                dataValueDescriptorArray4 = (DataValueDescriptor[])object;
                l3 = ((SQLLongint)dataValueDescriptorArray4[2]).getLong();
                if (!hashSet.remove(l3)) {
                    return T_QualifierTest.fail("(t_scanFetchHashtable-obj) wrong key, expected (" + n4 + ")but got (" + l3 + ").");
                }
                ++l2;
                continue;
            }
            if (object instanceof List) {
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    dataValueDescriptorArray4 = (DataValueDescriptor[])list.get(i);
                    l3 = ((SQLLongint)dataValueDescriptorArray4[2]).getLong();
                    if (!hashSet.remove(l3)) {
                        return T_QualifierTest.fail("(t_scanFetchHashtable-vector) wrong key, expected (" + n4 + ")but got (" + l3 + ").");
                    }
                    ++l2;
                }
                continue;
            }
            return T_QualifierTest.fail("(t_scanFetchHashtable) got bad type for data: " + object);
        }
        if (l2 != (long)n3) {
            return T_QualifierTest.fail("(t_scanFetchHashtable) wrong number of rows. Expected " + n3 + " rows, but got " + l2 + "rows.");
        }
        backingStoreHashtable.close();
        nArray[0] = 2;
        backingStoreHashtable = transactionController.createBackingStoreHashtableFromScan(l, 0, 7, 5, (FormatableBitSet)null, dataValueDescriptorArray2, n, qualifierArray, dataValueDescriptorArray3, n2, -1L, nArray, false, -1L, -1L, -1, -1.0f, false, false, false, false);
        for (l2 = 0L; l2 < (long)n3; ++l2) {
            long l4 = n5 == 4 ? (long)n4 - l2 : (long)n4 + l2;
            object = backingStoreHashtable.remove((Object)new SQLLongint(l4));
            if (object != null) continue;
            T_QualifierTest.fail("(t_scanFetchHashtable-2-vector) wrong key, expected (" + l4 + ")but did not find it.");
        }
        if (l2 != (long)n3) {
            return T_QualifierTest.fail("(t_scanFetchHashtable-2) wrong number of rows. Expected " + n3 + " rows, but got " + l2 + "rows.");
        }
        return true;
    }

    public boolean t_testqual(TransactionController transactionController) throws StandardException, T_Fail {
        long l;
        long l2;
        boolean bl = true;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        DataValueDescriptor[] dataValueDescriptorArray2 = null;
        DataValueDescriptor[] dataValueDescriptorArray3 = null;
        T_SecondaryIndexRow t_SecondaryIndexRow = null;
        long l3 = -1L;
        long[] lArray = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] lArray2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] lArray3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        ConglomerateController conglomerateController = null;
        ConglomerateController conglomerateController2 = null;
        RowLocation rowLocation = null;
        dataValueDescriptorArray3 = TemplateRow.newU8Row((int)3);
        if (this.init_conglomerate_type.compareTo("BTREE") == 0) {
            l2 = transactionController.createConglomerate("heap", dataValueDescriptorArray3, null, null, null, 0);
            t_SecondaryIndexRow = new T_SecondaryIndexRow();
            conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
            rowLocation = conglomerateController.newRowLocationTemplate();
            t_SecondaryIndexRow.init(dataValueDescriptorArray3, rowLocation, 4);
            long l4 = transactionController.createConglomerate(this.init_conglomerate_type, t_SecondaryIndexRow.getRow(), null, null, this.init_properties, this.init_temporary ? 1 : 0);
            conglomerateController2 = transactionController.openConglomerate(l4, false, 4, 6, 5);
            l = l4;
            dataValueDescriptorArray = t_SecondaryIndexRow.getRow();
            T_SecondaryIndexRow t_SecondaryIndexRow2 = new T_SecondaryIndexRow();
            t_SecondaryIndexRow2.init(TemplateRow.newU8Row((int)3), conglomerateController.newRowLocationTemplate(), 4);
            dataValueDescriptorArray2 = t_SecondaryIndexRow2.getRow();
        } else {
            l2 = transactionController.createConglomerate(this.init_conglomerate_type, dataValueDescriptorArray3, null, null, this.init_properties, this.init_temporary ? 1 : 0);
            conglomerateController = transactionController.openConglomerate(l2, false, 4, 6, 5);
            rowLocation = conglomerateController.newRowLocationTemplate();
            l = l2;
            dataValueDescriptorArray = dataValueDescriptorArray3;
            dataValueDescriptorArray2 = TemplateRow.newU8Row((int)3);
        }
        for (int i = lArray.length - 1; i >= 0; --i) {
            ((SQLLongint)dataValueDescriptorArray3[0]).setValue(lArray[i]);
            ((SQLLongint)dataValueDescriptorArray3[1]).setValue(lArray2[i]);
            ((SQLLongint)dataValueDescriptorArray3[2]).setValue(lArray3[i]);
            conglomerateController.insertAndFetchLocation(dataValueDescriptorArray3, rowLocation);
            if (this.init_conglomerate_type.compareTo("BTREE") != 0) continue;
            conglomerateController2.insert(t_SecondaryIndexRow.getRow());
        }
        transactionController.commit();
        SQLLongint sQLLongint = new SQLLongint(-1L);
        SQLLongint sQLLongint2 = new SQLLongint(-1L);
        SQLLongint sQLLongint3 = new SQLLongint(-1L);
        SQLLongint sQLLongint4 = new SQLLongint(-1L);
        SQLLongint sQLLongint5 = new SQLLongint(-1L);
        SQLLongint sQLLongint6 = new SQLLongint(-1L);
        SQLLongint sQLLongint7 = new SQLLongint(-1L);
        this.progress("qual scan (x = 5)");
        sQLLongint.setValue(5);
        Qualifier[][] qualifierArrayArray = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray, null, 0, 3, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x > 5)");
        sQLLongint.setValue(5);
        Qualifier[][] qualifierArrayArray2 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 3, true, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray2, null, 0, 3, 19, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x >= 5)");
        sQLLongint.setValue(5);
        Qualifier[][] qualifierArrayArray3 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 1, true, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray3, null, 0, 6, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x <= 5)");
        sQLLongint.setValue(5);
        Qualifier[][] qualifierArrayArray4 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray4, null, 0, 8, 11, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x < 5)");
        sQLLongint.setValue(5);
        Qualifier[][] qualifierArrayArray5 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 1, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray5, null, 0, 5, 11, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x >= 5 and x <= 7)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(7);
        Qualifier[][] qualifierArrayArray6 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 1, true, true, true), new QualifierUtil(0, (DataValueDescriptor)sQLLongint2, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray6, null, 0, 5, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x >= 5 and x <= 7)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(7);
        Qualifier[][] qualifierArrayArray7 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 1, true, true, true)}, {new QualifierUtil(0, (DataValueDescriptor)sQLLongint2, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray7, null, 0, 5, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 5 and y > 2)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(2);
        Qualifier[][] qualifierArrayArray8 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)sQLLongint2, 3, true, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray8, null, 0, 2, 17, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 5 and y >= 2)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(2);
        Qualifier[][] qualifierArrayArray9 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)sQLLongint2, 1, true, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray9, null, 0, 3, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 5 and y < 5)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(5);
        Qualifier[][] qualifierArrayArray10 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)sQLLongint, 1, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray10, null, 0, 2, 16, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 2)");
        sQLLongint.setValue(2);
        Qualifier[][] qualifierArrayArray11 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true)}};
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray11, null, 0, 0, 0, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x >= 5) or (y = 6)");
        sQLLongint.setValue(5);
        sQLLongint2.setValue(6);
        Qualifier[][] qualifierArrayArray12 = new Qualifier[][]{new Qualifier[0], new Qualifier[2]};
        qualifierArrayArray12[1][0] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 5, false, true, true);
        qualifierArrayArray12[1][1] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint2, 2, false, true, true);
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray12, null, 0, 7, 15, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 1 or y = 1 or y = 6) and (x > 5 or y = 1) and (x = 9 or x = 7)");
        sQLLongint.setValue(1);
        sQLLongint2.setValue(1);
        sQLLongint3.setValue(6);
        sQLLongint4.setValue(5);
        sQLLongint5.setValue(1);
        sQLLongint6.setValue(9);
        sQLLongint7.setValue(7);
        Qualifier[][] qualifierArrayArray13 = new Qualifier[][]{new Qualifier[0], new Qualifier[3], new Qualifier[2], new Qualifier[2]};
        qualifierArrayArray13[1][0] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint, 2, false, true, true);
        qualifierArrayArray13[1][1] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint2, 2, false, true, true);
        qualifierArrayArray13[1][2] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint3, 2, false, true, true);
        qualifierArrayArray13[2][0] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint4, 4, false, true, true);
        qualifierArrayArray13[2][1] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint5, 2, false, true, true);
        qualifierArrayArray13[3][0] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint6, 2, false, true, true);
        qualifierArrayArray13[3][1] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint7, 2, false, true, true);
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray13, null, 0, 2, 20, this.init_order)) {
            bl = false;
        }
        this.progress("qual scan (x = 1 or x = 4 or x= 9) and (y = 4 or y = 1) and (z = 15 or z = 14)");
        sQLLongint.setValue(4);
        sQLLongint2.setValue(1);
        sQLLongint3.setValue(1);
        sQLLongint4.setValue(4);
        sQLLongint5.setValue(9);
        sQLLongint6.setValue(15);
        sQLLongint7.setValue(14);
        Qualifier[][] qualifierArrayArray14 = new Qualifier[][]{new Qualifier[0], new Qualifier[2], new Qualifier[3], new Qualifier[2]};
        qualifierArrayArray14[1][0] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint, 2, false, true, true);
        qualifierArrayArray14[1][1] = new QualifierUtil(1, (DataValueDescriptor)sQLLongint2, 2, false, true, true);
        qualifierArrayArray14[2][0] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint4, 2, false, true, true);
        qualifierArrayArray14[2][1] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint5, 2, false, true, true);
        qualifierArrayArray14[2][2] = new QualifierUtil(0, (DataValueDescriptor)sQLLongint3, 2, false, true, true);
        qualifierArrayArray14[3][0] = new QualifierUtil(2, (DataValueDescriptor)sQLLongint6, 2, false, true, true);
        qualifierArrayArray14[3][1] = new QualifierUtil(2, (DataValueDescriptor)sQLLongint7, 2, false, true, true);
        if (!T_QualifierTest.t_scan(transactionController, l, dataValueDescriptorArray, dataValueDescriptorArray2, null, 0, qualifierArrayArray14, null, 0, 1, 14, this.init_order)) {
            bl = false;
        }
        transactionController.commit();
        this.progress("Ending t_testqual");
        return bl;
    }

    private static boolean fail(String string) throws T_Fail {
        throw T_Fail.testFailMsg("T_QualifierTest failure: " + string);
    }

    private void progress(String string) {
        this.init_out.println("T_QualifierTest progress: " + string);
    }
}

