/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public class RoleGrantDescriptor
extends TupleDescriptor
implements Provider {
    private final UUID uuid;
    private final String roleName;
    private final String grantee;
    private final String grantor;
    private boolean withAdminOption;
    private final boolean isDef;

    public RoleGrantDescriptor(DataDictionary dd, UUID uuid, String roleName, String grantee, String grantor, boolean withAdminOption, boolean isDef) {
        super(dd);
        this.uuid = uuid;
        this.roleName = roleName;
        this.grantee = grantee;
        this.grantor = grantor;
        this.withAdminOption = withAdminOption;
        this.isDef = isDef;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public boolean isDef() {
        return this.isDef;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isWithAdminOption() {
        return this.withAdminOption;
    }

    public void setWithAdminOption(boolean b) {
        this.withAdminOption = b;
    }

    public String toString() {
        return "uuid: " + this.uuid + "\nroleName: " + this.roleName + "\ngrantor: " + this.grantor + "\ngrantee: " + this.grantee + "\nwithadminoption: " + this.withAdminOption + "\nisDef: " + this.isDef + "\n";
    }

    @Override
    public String getDescriptorType() {
        return "Role";
    }

    @Override
    public String getDescriptorName() {
        return this.roleName + " " + this.grantor + " " + this.grantee;
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.dropRoleGrant(this.roleName, this.grantee, this.grantor, tc);
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String getObjectName() {
        return (this.isDef ? "CREATE ROLE: " : "GRANT ROLE: ") + this.roleName + " GRANT TO: " + this.grantee + " GRANTED BY: " + this.grantor + (this.withAdminOption ? " WITH ADMIN OPTION" : "");
    }

    @Override
    public String getClassType() {
        return "RoleGrant";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(471);
    }
}

