/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.clients.BackToBackLoadGenerator;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.SingleRecordFiller;
import org.apache.derbyTesting.perf.clients.SingleRecordSelectClient;

public class BlobAccessTest
extends JDBCPerfTestCase {
    private static final boolean disableSmallBlobs = Boolean.getBoolean("derby.tests.disableSmallBlobs");
    private static final boolean disableLargeBlobs = Boolean.getBoolean("derby.tests.disableLargeBlobs");
    private static final boolean disableConcurrencyTest = Boolean.getBoolean("derby.tests.disableConcurrencyTest");
    private static final int largeBlobSizeMB = Integer.getInteger("derby.tests.largeBlobSize", 15);
    private static final int FETCH_GETBYTES = 0;
    private static final int FETCH_GETBINARYSTREAM = 1;

    public BlobAccessTest(String string, int n, int n2) {
        super(string, n, n2);
    }

    @Override
    public void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite;
        int n;
        int n2;
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("BlobAccessTest suite");
        if (!disableSmallBlobs) {
            n2 = 50;
            n = 3;
            BlobAccessTest.println("Adding small Blob tests.");
            baseTestSuite = new BaseTestSuite("Small Blob suite");
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchSmallBlobs", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchSmallBlobsInaccurateLength", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testModifySmallBlobs", n2, n));
            baseTestSuite2.addTest((Test)baseTestSuite);
        }
        if (!disableLargeBlobs) {
            n2 = 5;
            n = 3;
            BlobAccessTest.println("Adding large Blob tests.");
            baseTestSuite = new BaseTestSuite("Large Blob suite");
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobs", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByteBaseline", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByteModified", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobOneByOneByte", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlob", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobModified", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobPieceByPiece", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testFetchLargeBlobPieceByPieceModified", n2, n));
            baseTestSuite.addTest((Test)new BlobAccessTest("testLargeBlobGetLength", n2, n));
            baseTestSuite2.addTest((Test)baseTestSuite);
        }
        if (!disableConcurrencyTest) {
            baseTestSuite2.addTest((Test)new BlobAccessTest("testConcurrency", 1, 1));
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite2){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                try {
                    BlobAccessTest.initializeBlobData(statement);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLException sQLException = new SQLException();
                    sQLException.initCause(unsupportedEncodingException);
                    throw sQLException;
                }
            }
        };
    }

    public void testFetchSmallBlobs() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            int n = resultSet.getInt(2);
            byte[] byArray = blob.getBytes(1L, n);
        }
        resultSet.close();
    }

    public void testFetchSmallBlobsInaccurateLength() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            int n = resultSet.getInt(2);
            byte[] byArray = blob.getBytes(1L, 100);
        }
        resultSet.close();
    }

    public void testModifySmallBlobs() throws SQLException, UnsupportedEncodingException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from smallBlobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            int n = resultSet.getInt(2);
            blob.setBytes(n, "X".getBytes("US-ASCII"));
            byte[] byArray = blob.getBytes(1L, 100);
        }
        resultSet.close();
    }

    public void testFetchLargeBlobs() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs");
        ResultSet resultSet = preparedStatement.executeQuery();
        byte[] byArray = new byte[16384];
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            InputStream inputStream = blob.getBinaryStream();
            for (long i = (long)resultSet.getInt(2); i > 0L; i -= (long)inputStream.read(byArray)) {
            }
            inputStream.close();
        }
        resultSet.close();
    }

    public void testFetchLargeBlobOneByOneByteBaseline() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            InputStream inputStream = blob.getBinaryStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            long l = resultSet.getInt(2);
            while (bufferedInputStream.read() != -1) {
                --l;
            }
            inputStream.close();
            BlobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeBlobOneByOneByte() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            InputStream inputStream = blob.getBinaryStream();
            long l = resultSet.getInt(2);
            while (inputStream.read() != -1) {
                --l;
            }
            inputStream.close();
            BlobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeBlobOneByOneByteModified() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            long l = resultSet.getInt(2);
            blob.setBytes(++l, "X".getBytes("US-ASCII"));
            InputStream inputStream = blob.getBinaryStream();
            while (inputStream.read() != -1) {
                --l;
            }
            inputStream.close();
            BlobAccessTest.assertEquals((long)0L, (long)l);
        }
        resultSet.close();
    }

    public void testFetchLargeBlobPieceByPiece() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(false, 0);
    }

    public void testFetchLargeBlobPieceByPieceModified() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(true, 0);
    }

    public void testFetchLargeBlob() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(false, 1);
    }

    public void testFetchLargeBlobModified() throws IOException, SQLException {
        this.fetchBlobPieceByPiece(true, 1);
    }

    private void fetchBlobPieceByPiece(boolean bl, int n) throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 4");
        ResultSet resultSet = preparedStatement.executeQuery();
        block4: while (resultSet.next()) {
            long l;
            Blob blob = resultSet.getBlob(1);
            long l2 = resultSet.getInt(2);
            if (bl) {
                l = System.currentTimeMillis();
                blob.setBytes(++l2, new byte[]{88});
                BlobAccessTest.println("Blob modification duration: " + (System.currentTimeMillis() - l) + " ms");
            }
            l = 1L;
            int n2 = 32676;
            switch (n) {
                case 0: {
                    Object object;
                    while (l2 > 0L) {
                        object = blob.getBytes(l, (int)Math.min((long)n2, l2));
                        l += (long)((Object)object).length;
                        l2 -= (long)((Object)object).length;
                    }
                    continue block4;
                }
                case 1: {
                    Object object = blob.getBinaryStream();
                    byte[] byArray = new byte[n2];
                    while (l2 > 0L) {
                        int n3 = ((InputStream)object).read(byArray);
                        l += (long)n3;
                        l2 -= (long)n3;
                    }
                    ((InputStream)object).close();
                    continue block4;
                }
            }
            BlobAccessTest.fail((String)("Unknown fetch mode: " + n));
        }
        resultSet.close();
    }

    public void testLargeBlobGetLength() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 7");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            long l = resultSet.getInt(2);
            for (int i = 0; i < 50; ++i) {
                BlobAccessTest.assertEquals((long)l, (long)blob.length());
            }
        }
        resultSet.close();
    }

    public void testLargeBlobGetLengthModified() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob, length from largeBlobs where id = 7");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(1);
            blob.setBytes(1L, new byte[]{88});
            long l = resultSet.getInt(2);
            for (int i = 0; i < 50; ++i) {
                BlobAccessTest.assertEquals((long)l, (long)blob.length());
            }
        }
        resultSet.close();
    }

    public void testConcurrency() throws InterruptedException, SQLException {
        SingleRecordFiller singleRecordFiller = new SingleRecordFiller(100000, 1, 2004, false, false);
        Connection connection = this.getConnection();
        BlobAccessTest.println("initializing database...");
        singleRecordFiller.fill(connection);
        connection.close();
        Client[] clientArray = new Client[16];
        for (int i = 0; i < clientArray.length; ++i) {
            Connection connection2 = this.openDefaultConnection();
            connection2.setTransactionIsolation(2);
            clientArray[i] = new SingleRecordSelectClient(100000, 1, 2004, false, false);
            clientArray[i].init(connection2);
        }
        BackToBackLoadGenerator backToBackLoadGenerator = new BackToBackLoadGenerator();
        backToBackLoadGenerator.init(clientArray);
        BlobAccessTest.println("starting warmup...");
        backToBackLoadGenerator.startWarmup();
        Thread.sleep(30000L);
        BlobAccessTest.println("entering steady state...");
        backToBackLoadGenerator.startSteadyState();
        Thread.sleep(60000L);
        BlobAccessTest.println("stopping threads...");
        backToBackLoadGenerator.stop();
        backToBackLoadGenerator.printReport(System.out);
    }

    private static void initializeBlobData(Statement statement) throws SQLException, UnsupportedEncodingException {
        int n;
        PreparedStatement preparedStatement;
        Connection connection = statement.getConnection();
        connection.setAutoCommit(false);
        if (!disableSmallBlobs) {
            BlobAccessTest.println("Generating small Blobs test data.");
            try {
                statement.executeUpdate("drop table smallBlobs");
            }
            catch (SQLException sQLException) {
                BlobAccessTest.assertSQLState("42Y55", sQLException);
            }
            statement.executeUpdate("create table smallBlobs (dBlob Blob, length int)");
            preparedStatement = connection.prepareStatement("insert into smallBlobs values (?,?)");
            for (n = 1; n < 15001; ++n) {
                byte[] byArray = Integer.toString(n).getBytes("US-ASCII");
                preparedStatement.setBytes(1, byArray);
                preparedStatement.setInt(2, byArray.length);
                preparedStatement.executeUpdate();
                if (n % 1000 != 0) continue;
                connection.commit();
            }
            connection.commit();
        }
        if (!disableLargeBlobs) {
            BlobAccessTest.println("Generating large Blobs test data.");
            try {
                statement.executeUpdate("drop table largeBlobs");
            }
            catch (SQLException sQLException) {
                BlobAccessTest.assertSQLState("42Y55", sQLException);
            }
            statement.executeUpdate("create table largeBlobs (id int unique not null, dBlob Blob, length int)");
            preparedStatement = connection.prepareStatement("insert into largeBlobs values (?,?,?)");
            n = largeBlobSizeMB * 1024 * 1024;
            for (int i = 1; i < 11; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(n), n);
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
            }
            connection.commit();
        }
    }
}

