/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.List;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToEstimateAndErrorBoundsUDFTest {
    @Test
    public void nullSketch() {
        List result = new ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        List result = new ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.0);
    }

    @Test
    public void exactMode() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{0.0});
        sketch.update(2L, new double[]{0.0});
        List result = new ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)2.0);
    }

    @Test
    public void estimationMode() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        int numKeys = 10000;
        for (int i = 0; i < numKeys; ++i) {
            sketch.update((long)i, new double[]{0.0});
        }
        List result = new ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        double estimate = (Double)result.get(0);
        double lowerBound = (Double)result.get(1);
        double upperBound = (Double)result.get(2);
        Assert.assertEquals((double)estimate, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertEquals((double)lowerBound, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertEquals((double)upperBound, (double)numKeys, (double)((double)numKeys * 0.04));
        Assert.assertTrue((lowerBound < estimate ? 1 : 0) != 0);
        Assert.assertTrue((upperBound > estimate ? 1 : 0) != 0);
    }
}

