/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.IterativeLegendreGaussIntegrator;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RealDistributionAbstractTest {
    private RealDistribution distribution;
    private double tolerance = 1.0E-4;
    private double[] cumulativeTestPoints;
    private double[] cumulativeTestValues;
    private double[] inverseCumulativeTestPoints;
    private double[] inverseCumulativeTestValues;
    private double[] densityTestValues;
    private double[] logDensityTestValues;

    public abstract RealDistribution makeDistribution();

    public abstract double[] makeCumulativeTestPoints();

    public abstract double[] makeCumulativeTestValues();

    public abstract double[] makeDensityTestValues();

    public double[] makeLogDensityTestValues() {
        double[] densityTestValues = this.makeDensityTestValues();
        double[] logDensityTestValues = new double[densityTestValues.length];
        for (int i = 0; i < densityTestValues.length; ++i) {
            logDensityTestValues[i] = FastMath.log((double)densityTestValues[i]);
        }
        return logDensityTestValues;
    }

    public double[] makeInverseCumulativeTestPoints() {
        return this.makeCumulativeTestValues();
    }

    public double[] makeInverseCumulativeTestValues() {
        return this.makeCumulativeTestPoints();
    }

    @Before
    public void setUp() {
        this.distribution = this.makeDistribution();
        this.cumulativeTestPoints = this.makeCumulativeTestPoints();
        this.cumulativeTestValues = this.makeCumulativeTestValues();
        this.inverseCumulativeTestPoints = this.makeInverseCumulativeTestPoints();
        this.inverseCumulativeTestValues = this.makeInverseCumulativeTestValues();
        this.densityTestValues = this.makeDensityTestValues();
        this.logDensityTestValues = this.makeLogDensityTestValues();
    }

    @After
    public void tearDown() {
        this.distribution = null;
        this.cumulativeTestPoints = null;
        this.cumulativeTestValues = null;
        this.inverseCumulativeTestPoints = null;
        this.inverseCumulativeTestValues = null;
        this.densityTestValues = null;
        this.logDensityTestValues = null;
    }

    protected void verifyCumulativeProbabilities() {
        int i;
        for (i = 0; i < this.cumulativeTestPoints.length; ++i) {
            TestUtils.assertEquals("Incorrect cumulative probability value returned for " + this.cumulativeTestPoints[i], this.cumulativeTestValues[i], this.distribution.cumulativeProbability(this.cumulativeTestPoints[i]), this.getTolerance());
        }
        for (i = 0; i < this.cumulativeTestPoints.length; ++i) {
            for (int j = 0; j < this.cumulativeTestPoints.length; ++j) {
                if (this.cumulativeTestPoints[i] <= this.cumulativeTestPoints[j]) {
                    TestUtils.assertEquals(this.cumulativeTestValues[j] - this.cumulativeTestValues[i], this.distribution.cumulativeProbability(this.cumulativeTestPoints[i], this.cumulativeTestPoints[j]), this.getTolerance());
                    continue;
                }
                try {
                    this.distribution.cumulativeProbability(this.cumulativeTestPoints[i], this.cumulativeTestPoints[j]);
                }
                catch (NumberIsTooLargeException e) {
                    continue;
                }
                Assert.fail((String)"distribution.cumulativeProbability(double, double) should have thrown an exception that second argument is too large");
            }
        }
    }

    protected void verifyInverseCumulativeProbabilities() {
        for (int i = 0; i < this.inverseCumulativeTestPoints.length; ++i) {
            TestUtils.assertEquals("Incorrect inverse cumulative probability value returned for " + this.inverseCumulativeTestPoints[i], this.inverseCumulativeTestValues[i], this.distribution.inverseCumulativeProbability(this.inverseCumulativeTestPoints[i]), this.getTolerance());
        }
    }

    protected void verifyDensities() {
        for (int i = 0; i < this.cumulativeTestPoints.length; ++i) {
            TestUtils.assertEquals("Incorrect probability density value returned for " + this.cumulativeTestPoints[i], this.densityTestValues[i], this.distribution.density(this.cumulativeTestPoints[i]), this.getTolerance());
        }
    }

    protected void verifyLogDensities() {
        for (int i = 0; i < this.cumulativeTestPoints.length; ++i) {
            TestUtils.assertEquals("Incorrect probability density value returned for " + this.cumulativeTestPoints[i], this.logDensityTestValues[i], ((AbstractRealDistribution)this.distribution).logDensity(this.cumulativeTestPoints[i]), this.getTolerance());
        }
    }

    @Test
    public void testCumulativeProbabilities() {
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testInverseCumulativeProbabilities() {
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testDensities() {
        this.verifyDensities();
    }

    @Test
    public void testLogDensities() {
        this.verifyLogDensities();
    }

    @Test
    public void testConsistency() {
        for (int i = 1; i < this.cumulativeTestPoints.length; ++i) {
            TestUtils.assertEquals(0.0, this.distribution.cumulativeProbability(this.cumulativeTestPoints[i], this.cumulativeTestPoints[i]), this.tolerance);
            double upper = FastMath.max((double)this.cumulativeTestPoints[i], (double)this.cumulativeTestPoints[i - 1]);
            double lower = FastMath.min((double)this.cumulativeTestPoints[i], (double)this.cumulativeTestPoints[i - 1]);
            double diff = this.distribution.cumulativeProbability(upper) - this.distribution.cumulativeProbability(lower);
            double direct = this.distribution.cumulativeProbability(lower, upper);
            TestUtils.assertEquals("Inconsistent cumulative probabilities for (" + lower + "," + upper + ")", diff, direct, this.tolerance);
        }
    }

    @Test
    public void testIllegalArguments() {
        try {
            this.distribution.cumulativeProbability(1.0, 0.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for bad cumulativeProbability interval");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.distribution.inverseCumulativeProbability(-1.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for p = -1");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.distribution.inverseCumulativeProbability(2.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for p = 2");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSampling() {
        int sampleSize = 1000;
        this.distribution.reseedRandomGenerator(1000L);
        double[] sample = this.distribution.sample(1000);
        double[] quartiles = TestUtils.getDistributionQuartiles(this.distribution);
        double[] expected = new double[]{250.0, 250.0, 250.0, 250.0};
        long[] counts = new long[4];
        for (int i = 0; i < 1000; ++i) {
            TestUtils.updateCounts(sample[i], counts, quartiles);
        }
        TestUtils.assertChiSquareAccept(expected, counts, 0.001);
    }

    @Test
    public void testDensityIntegrals() {
        int i;
        double tol = 1.0E-9;
        IterativeLegendreGaussIntegrator integrator = new IterativeLegendreGaussIntegrator(5, 1.0E-12, 1.0E-10);
        UnivariateFunction d = new UnivariateFunction(){

            public double value(double x) {
                return RealDistributionAbstractTest.this.distribution.density(x);
            }
        };
        ArrayList<Double> integrationTestPoints = new ArrayList<Double>();
        for (i = 0; i < this.cumulativeTestPoints.length; ++i) {
            if (Double.isNaN(this.cumulativeTestValues[i]) || this.cumulativeTestValues[i] < 1.0E-5 || this.cumulativeTestValues[i] > 0.99999) continue;
            integrationTestPoints.add(this.cumulativeTestPoints[i]);
        }
        Collections.sort(integrationTestPoints);
        for (i = 1; i < integrationTestPoints.size(); ++i) {
            Assert.assertEquals((double)this.distribution.cumulativeProbability(((Double)integrationTestPoints.get(0)).doubleValue(), ((Double)integrationTestPoints.get(i)).doubleValue()), (double)integrator.integrate(1000000, d, ((Double)integrationTestPoints.get(0)).doubleValue(), ((Double)integrationTestPoints.get(i)).doubleValue()), (double)1.0E-9);
        }
    }

    @Test
    public void testIsSupportLowerBoundInclusive() {
        double lowerBound = this.distribution.getSupportLowerBound();
        double result = Double.NaN;
        result = this.distribution.density(lowerBound);
        Assert.assertEquals((Object)(!Double.isInfinite(lowerBound) && !Double.isNaN(result) && !Double.isInfinite(result) ? 1 : 0), (Object)this.distribution.isSupportLowerBoundInclusive());
    }

    @Test
    public void testIsSupportUpperBoundInclusive() {
        double upperBound = this.distribution.getSupportUpperBound();
        double result = Double.NaN;
        result = this.distribution.density(upperBound);
        Assert.assertEquals((Object)(!Double.isInfinite(upperBound) && !Double.isNaN(result) && !Double.isInfinite(result) ? 1 : 0), (Object)this.distribution.isSupportUpperBoundInclusive());
    }

    @Test
    public void testDistributionClone() throws IOException, ClassNotFoundException {
        this.distribution.reseedRandomGenerator(123L);
        this.distribution.sample();
        RealDistribution cloned = this.deepClone();
        double s1 = this.distribution.sample();
        double s2 = cloned.sample();
        Assert.assertEquals((double)s1, (double)s2, (double)0.0);
    }

    protected double[] getCumulativeTestPoints() {
        return this.cumulativeTestPoints;
    }

    protected void setCumulativeTestPoints(double[] cumulativeTestPoints) {
        this.cumulativeTestPoints = cumulativeTestPoints;
    }

    protected double[] getCumulativeTestValues() {
        return this.cumulativeTestValues;
    }

    protected void setCumulativeTestValues(double[] cumulativeTestValues) {
        this.cumulativeTestValues = cumulativeTestValues;
    }

    protected double[] getDensityTestValues() {
        return this.densityTestValues;
    }

    protected void setDensityTestValues(double[] densityTestValues) {
        this.densityTestValues = densityTestValues;
    }

    protected RealDistribution getDistribution() {
        return this.distribution;
    }

    protected void setDistribution(RealDistribution distribution) {
        this.distribution = distribution;
    }

    protected double[] getInverseCumulativeTestPoints() {
        return this.inverseCumulativeTestPoints;
    }

    protected void setInverseCumulativeTestPoints(double[] inverseCumulativeTestPoints) {
        this.inverseCumulativeTestPoints = inverseCumulativeTestPoints;
    }

    protected double[] getInverseCumulativeTestValues() {
        return this.inverseCumulativeTestValues;
    }

    protected void setInverseCumulativeTestValues(double[] inverseCumulativeTestValues) {
        this.inverseCumulativeTestValues = inverseCumulativeTestValues;
    }

    protected double getTolerance() {
        return this.tolerance;
    }

    protected void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private RealDistribution deepClone() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(this.distribution);
        byte[] data = bOut.toByteArray();
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        ObjectInputStream oIn = new ObjectInputStream(bIn);
        Object clone = oIn.readObject();
        oIn.close();
        return (RealDistribution)clone;
    }
}

