/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBMetaStatement;
import org.apache.asterix.jdbc.core.ADBProductVersion;
import org.apache.asterix.jdbc.core.ADBResultSet;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;

public class ADBDatabaseMetaData
extends ADBWrapperSupport
implements DatabaseMetaData {
    private static final int METADATA_OBJECT_NAME_LENGTH_LIMIT_UTF8 = 251;
    protected final ADBMetaStatement metaStatement;
    protected final ADBProductVersion driverVersion;
    protected final ADBProductVersion databaseVersion;

    public ADBDatabaseMetaData(ADBMetaStatement metaStatement, ADBProductVersion databaseVersion) {
        this.metaStatement = Objects.requireNonNull(metaStatement);
        this.driverVersion = metaStatement.connection.protocol.getDriverContext().getDriverVersion();
        this.databaseVersion = databaseVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverVersion.getProductName();
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion.getProductVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverVersion.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverVersion.getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseVersion.getProductName();
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseVersion.getProductVersion();
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.databaseVersion.getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.databaseVersion.getMinorVersion();
    }

    @Override
    public ADBResultSet getCatalogs() throws SQLException {
        return this.metaStatement.executeGetCatalogsQuery();
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 251;
    }

    @Override
    public ADBResultSet getSchemas() throws SQLException {
        return this.metaStatement.executeGetSchemasQuery();
    }

    @Override
    public ADBResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.metaStatement.executeGetSchemasQuery(catalog, schemaPattern);
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 251;
    }

    protected boolean supportsCatalogsInStatements() {
        return false;
    }

    protected boolean supportsSchemasInStatements() {
        return false;
    }

    @Override
    public ADBResultSet getTableTypes() throws SQLException {
        return this.metaStatement.executeGetTableTypesQuery();
    }

    @Override
    public ADBResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.metaStatement.executeGetTablesQuery(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ADBResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public int getMaxTableNameLength() {
        return 251;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public ADBResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.metaStatement.executeGetColumnsQuery(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ADBResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public ADBResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.metaStatement.executeGetPrimaryKeysQuery(catalog, schema, table);
    }

    @Override
    public ADBResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.metaStatement.executeGetImportedKeysQuery(catalog, schema, table);
    }

    @Override
    public ADBResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.metaStatement.executeGetExportedKeysQuery(catalog, schema, table);
    }

    @Override
    public ADBResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.metaStatement.executeCrossReferenceQuery(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ADBResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public ADBResultSet getTypeInfo() throws SQLException {
        return this.metaStatement.executeGetTypeInfoQuery();
    }

    @Override
    public ADBResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public ADBResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 251;
    }

    @Override
    public ADBResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public ADBResultSet getClientInfoProperties() throws SQLException {
        return this.metaStatement.executeEmptyResultQuery();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public String getSQLKeywords() {
        return "adapter,apply,asc,autogenerated,btree,closed,compaction,compact,correlate,collection,dataset,dataverse,definition,desc,disconnect,div,explain,enforced,every,feed,flatten,fulltext,hints,if,index,ingestion,internal,keyword,key,known,letting,let,limit,load,missing,mod,nodegroup,ngram,offset,path,policy,pre-sorted,raw,refresh,returning,rtree,run,satisfies,secondary,some,stop,synonym,temporary,type,upsert,use,view,write";
    }

    @Override
    public String getCatalogTerm() {
        return "catalog";
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "current_date,current_time,current_datetime";
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInStatements();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return this.supportsSchemasInStatements();
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInStatements();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return this.supportsSchemasInStatements();
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return this.supportsCatalogsInStatements();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return this.supportsSchemasInStatements();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return this.supportsCatalogsInStatements();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return this.supportsSchemasInStatements();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInStatements();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return this.supportsSchemasInStatements();
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 2 == level;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.metaStatement.connection;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public String getURL() {
        return this.metaStatement.connection.url;
    }

    @Override
    public String getUserName() {
        return this.metaStatement.connection.protocol.getUser();
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.metaStatement.getErrorReporter();
    }
}

