<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class TransactionLogRecord
	{
		// Properties
		private $_id;
		public $Thermostat;
		public $ThermostatObject;
		public $OldValue;
		public $NewValue;
		public $TransTimeStamp;

		// Constructor
		public function __construct()
		{
			$numargs = func_num_args();
			$args = func_get_args();

			switch($numargs)
			{
				case 2:

					if(is_a($args[0], 'IPThermostat'))
					{
						$this->_id = -1;
						$this->Thermostat = $args[0];
						$this->ThermostatObject = $args[1];
						$this->OldValue = '';
						$this->NewValue = '';
						$this->TransTimeStamp = '';
					}
					else
					{
						$this->_id = $args[0];
						$this->Thermostat = new IPThermostat();
						$this->ThermostatObject = new IPThermostatObject();
						$this->OldValue = '';
						$this->NewValue = '';
						$this->TransTimeStamp = '';

						if($args[1] === true)
						{
							$this->Load();
						}
					}

					break;

				case 6:

					$this->_id = $args[0];
					$this->Thermostat = new IPThermostat($args[1], true);
					$this->ThermostatObject = new IPThermostatObject('OID'.$args[2]);
					$this->OldValue = $args[3];
					$this->NewValue = $args[4];
					$this->TransTimeStamp = $args[5];

					break;

				default:

					$this->_id = -1;
					$this->Thermostat = new IPThermostat();
					$this->ThermostatObject = new IPThermostatObject();
					$this->OldValue = '';
					$this->NewValue = '';
					$this->TransTimeStamp = '';

					break;
			}
		}

		// Methods
		public function Load()
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;
			$dataAccess->Command->CommandText = "CALL sp_Transaction_Log_Load_Details($this->_id)";
			$dataAccess->GetData();

			$row = $dataAccess->ResultSet->fetch_assoc();

			$this->Thermostat = new IPThermostat($row['ThermostatId'], true);
			$this->ThermostatObject = new IPThermostatObject('OID'.$row['OID']);
			$this->OldValue = $row['OldValue'];
			$this->NewValue = $row['NewValue'];
			$this->TransTimeStamp = $row['TransactionTimeStamp'];

			$dataAccess->Cleanup();
		}

		public function Save($userId)
		{
			$dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;
			$dataAccess->Command->CommandText = 'CALL sp_Transaction_Log_Insert('.$this->Thermostat->ID.', \''.substr($this->ThermostatObject->OID, 3).'\', \''.$this->ThermostatObject->CurrentValue.'\', \''.$this->ThermostatObject->NewValue.'\', '.$userId.')';

			if(!$dataAccess->Command->ExecuteNonQuery())
			{
				$error = $dataAccess->Command->Connection->error;

				$dataAccess->Cleanup();

				throw new DatabaseException($error);
			}

			$dataAccess->Cleanup();
		}
	}

?>
