/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.LocationEnumeration;
import gnu.mapping.NameMap;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;
import java.util.Hashtable;

public abstract class Environment
extends NameMap {
    static Environment global;
    static final int CAN_DEFINE = 1;
    static final int CAN_REDEFINE = 2;
    static final int CAN_IMPLICITLY_DEFINE = 4;
    static final int THREAD_SAFE = 8;
    static final int DIRECT_INHERITED_ON_SET = 16;
    public static final int INDIRECT_DEFINES = 32;
    int flags = 23;
    static final Hashtable envTable;

    public static void setGlobal(Environment environment) {
        global = environment;
    }

    public static Environment getGlobal() {
        return global;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public boolean getCanDefine() {
        return (this.flags & 1) != 0;
    }

    public void setCanDefine(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean getCanRedefine() {
        return (this.flags & 2) != 0;
    }

    public void setCanRedefine(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean isLocked() {
        return (this.flags & 3) == 0;
    }

    public void setLocked() {
        this.flags &= 0xFFFFFFF8;
    }

    public final void setIndirectDefines() {
        this.flags |= 0x20;
        ((InheritingEnvironment)this).baseTimestamp = Integer.MAX_VALUE;
    }

    public final Location getLocation(Symbol symbol, Object object2) {
        return this.getLocation(symbol, object2, true);
    }

    public final Location getLocation(Symbol symbol) {
        return this.getLocation(symbol, null, true);
    }

    public final Location lookup(Symbol symbol, Object object2) {
        return this.getLocation(symbol, object2, false);
    }

    public abstract NamedLocation lookup(Symbol var1, Object var2, int var3);

    public final Location lookup(Symbol symbol) {
        return this.getLocation(symbol, null, false);
    }

    public abstract NamedLocation getLocation(Symbol var1, Object var2, int var3, boolean var4);

    public final NamedLocation getLocation(Symbol symbol, Object object2, boolean bl) {
        int n = symbol.hashCode() ^ System.identityHashCode(object2);
        return this.getLocation(symbol, object2, n, bl);
    }

    public final Location getLocation(Object object2, boolean bl) {
        EnvironmentKey environmentKey;
        Object object3 = null;
        if (object2 instanceof EnvironmentKey) {
            environmentKey = (EnvironmentKey)object2;
            object2 = environmentKey.getKeySymbol();
            object3 = environmentKey.getKeyProperty();
        }
        environmentKey = object2 instanceof Symbol ? (Symbol)object2 : this.getSymbol((String)object2);
        return this.getLocation((Symbol)environmentKey, object3, bl);
    }

    public boolean isBound(Symbol symbol, Object object2) {
        Location location2 = this.lookup(symbol, object2);
        if (location2 == null) {
            return false;
        }
        return location2.isBound();
    }

    public final boolean isBound(Symbol symbol) {
        return this.isBound(symbol, null);
    }

    public final boolean containsKey(Object object2) {
        EnvironmentKey environmentKey;
        Object object3 = null;
        if (object2 instanceof EnvironmentKey) {
            environmentKey = (EnvironmentKey)object2;
            object2 = environmentKey.getKeySymbol();
            object3 = environmentKey.getKeyProperty();
        }
        environmentKey = object2 instanceof Symbol ? (Symbol)object2 : this.getSymbol((String)object2);
        return this.isBound((Symbol)environmentKey, object3);
    }

    public Object get(Symbol symbol, Object object2, Object object3) {
        Location location2 = this.lookup(symbol, object2);
        if (location2 == null) {
            return object3;
        }
        return location2.get(object3);
    }

    public final Object get(EnvironmentKey environmentKey, Object object2) {
        Symbol symbol = environmentKey.getKeySymbol();
        Object object3 = environmentKey.getKeyProperty();
        return this.get(symbol, object3, object2);
    }

    public final Object get(String string, Object object2) {
        return this.get(this.getSymbol(string), null, object2);
    }

    public Object get(Symbol symbol) {
        String string = Location.UNBOUND;
        Object object2 = this.get(symbol, null, string);
        if (object2 == string) {
            throw new UnboundLocationException(symbol);
        }
        return object2;
    }

    public final Object getFunction(Symbol symbol, Object object2) {
        return this.get(symbol, EnvironmentKey.FUNCTION, object2);
    }

    public final Object getFunction(Symbol symbol) {
        String string = Location.UNBOUND;
        Object object2 = this.get(symbol, EnvironmentKey.FUNCTION, string);
        if (object2 == string) {
            throw new UnboundLocationException(symbol);
        }
        return object2;
    }

    public final Object get(Object object2) {
        EnvironmentKey environmentKey;
        Object object3 = null;
        if (object2 instanceof EnvironmentKey) {
            environmentKey = (EnvironmentKey)object2;
            object2 = environmentKey.getKeySymbol();
            object3 = environmentKey.getKeyProperty();
        }
        environmentKey = object2 instanceof Symbol ? (Symbol)object2 : this.getSymbol((String)object2);
        return this.get((Symbol)environmentKey, object3, null);
    }

    public void put(Symbol symbol, Object object2, Object object3) {
        Location location2 = this.getLocation(symbol, object2);
        if (location2.isConstant()) {
            this.define(symbol, object2, object3);
        } else {
            location2.set(object3);
        }
    }

    public abstract void define(Symbol var1, Object var2, Object var3);

    public final void put(Symbol symbol, Object object2) {
        this.put(symbol, null, object2);
    }

    public final Object put(Object object2, Object object3) {
        Location location2 = this.getLocation(object2, true);
        Object object4 = location2.get(null);
        location2.set(object3);
        return object4;
    }

    public final void putFunction(Symbol symbol, Object object2) {
        this.put(symbol, EnvironmentKey.FUNCTION, object2);
    }

    public final Object put(String string, Object object2) {
        return this.put((Object)string, object2);
    }

    public Location unlink(Symbol symbol, Object object2, int n) {
        throw new RuntimeException("unsupported operation: unlink (aka undefine)");
    }

    public void remove(Symbol symbol, Object object2, int n) {
        Location location2 = this.unlink(symbol, object2, n);
        if (location2 != null) {
            location2.undefine();
        }
    }

    public Object remove(EnvironmentKey environmentKey) {
        int n;
        Object object2;
        Symbol symbol = environmentKey.getKeySymbol();
        NamedLocation namedLocation = this.getLocation(symbol, object2 = environmentKey.getKeyProperty(), n = symbol.hashCode() ^ System.identityHashCode(object2), false);
        if (namedLocation == null) {
            return null;
        }
        Object object3 = namedLocation.get(null);
        this.remove(symbol, object2, n);
        return object3;
    }

    public void remove(Symbol symbol, Object object2) {
        int n = symbol.hashCode() ^ System.identityHashCode(object2);
        this.remove(symbol, object2, n);
    }

    public final void remove(Symbol symbol) {
        this.remove(symbol, null);
    }

    public final void removeFunction(Symbol symbol) {
        this.remove(symbol, EnvironmentKey.FUNCTION);
    }

    public final Object remove(Object object2) {
        Location location2 = this.getLocation(object2, false);
        if (location2 == null) {
            return null;
        }
        Object object3 = location2.get(null);
        this.remove(location2);
        return object3;
    }

    public Namespace defaultNamespace() {
        return Namespace.getDefault();
    }

    public Symbol getSymbol(String string) {
        return this.defaultNamespace().getSymbol(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Environment getInstance(String string) {
        if (string == null) {
            string = "";
        }
        Hashtable hashtable = envTable;
        synchronized (hashtable) {
            Environment environment = (Environment)envTable.get(string);
            if (environment != null) {
                return environment;
            }
            environment = new SimpleEnvironment();
            environment.setName(string);
            envTable.put(string, environment);
            return environment;
        }
    }

    public abstract LocationEnumeration enumerateLocations();

    public abstract LocationEnumeration enumerateAllLocations();

    protected abstract boolean hasMoreElements(LocationEnumeration var1);

    public static Environment current() {
        return Environment.getCurrent();
    }

    public static Environment getCurrent() {
        return CallContext.getInstance().getEnvironment();
    }

    public static void setCurrent(Environment environment) {
        CallContext.getInstance().curEnvironment = environment;
    }

    public static Environment user() {
        return Environment.getCurrent();
    }

    public final void addLocation(NamedLocation namedLocation) {
        this.addLocation(namedLocation.getKeySymbol(), namedLocation.getKeyProperty(), namedLocation);
    }

    public abstract NamedLocation addLocation(Symbol var1, Object var2, Location var3);

    public final void addLocation(EnvironmentKey environmentKey, Location location2) {
        this.addLocation(environmentKey.getKeySymbol(), environmentKey.getKeyProperty(), location2);
    }

    public static SimpleEnvironment make() {
        return new SimpleEnvironment();
    }

    public static SimpleEnvironment make(String string) {
        return new SimpleEnvironment(string);
    }

    public static InheritingEnvironment make(String string, Environment environment) {
        return new InheritingEnvironment(string, environment);
    }

    public String toString() {
        return "#<environment " + this.getName() + '>';
    }

    public String toStringVerbose() {
        return this.toString();
    }

    static {
        envTable = new Hashtable(50);
    }
}

