/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KAttr;
import gnu.kawa.xml.KCDATASection;
import gnu.kawa.xml.KComment;
import gnu.kawa.xml.KDocument;
import gnu.kawa.xml.KElement;
import gnu.kawa.xml.KProcessingInstruction;
import gnu.kawa.xml.KText;
import gnu.lists.SeqPosition;
import gnu.lists.TreePosition;
import gnu.mapping.CharArrayOutPort;
import gnu.xml.NodeTree;
import gnu.xml.XMLPrinter;

public abstract class KNode
extends SeqPosition {
    public KNode(NodeTree nodeTree, int n) {
        super(nodeTree, n);
    }

    public static KNode coerce(Object object2) {
        if (object2 instanceof KNode) {
            return (KNode)object2;
        }
        if (object2 instanceof NodeTree) {
            NodeTree nodeTree = (NodeTree)object2;
            return KNode.make(nodeTree, nodeTree.startPos());
        }
        if (object2 instanceof SeqPosition && !(object2 instanceof TreePosition)) {
            SeqPosition seqPosition = (SeqPosition)object2;
            if (seqPosition.sequence instanceof NodeTree) {
                return KNode.make((NodeTree)seqPosition.sequence, seqPosition.ipos);
            }
        }
        return null;
    }

    public static KNode make(NodeTree nodeTree, int n) {
        int n2 = nodeTree.getNextKind(n);
        switch (n2) {
            case 33: {
                return new KElement(nodeTree, n);
            }
            case 35: {
                return new KAttr(nodeTree, n);
            }
            case 34: {
                return new KDocument(nodeTree, n);
            }
            case 31: {
                return new KCDATASection(nodeTree, n);
            }
            case 36: {
                return new KComment(nodeTree, n);
            }
            case 37: {
                return new KProcessingInstruction(nodeTree, n);
            }
            case 0: {
                if (nodeTree.isEmpty()) break;
                return null;
            }
        }
        return new KText(nodeTree, n);
    }

    public static KNode make(NodeTree nodeTree) {
        return KNode.make(nodeTree, 0);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public abstract short getNodeType();

    public String getNodeName() {
        return this.sequence.getNextTypeName(this.ipos);
    }

    public String getNamespaceURI() {
        return ((NodeTree)this.sequence).posNamespaceURI(this.ipos);
    }

    public String getPrefix() {
        return ((NodeTree)this.sequence).posPrefix(this.ipos);
    }

    public String getLocalName() {
        return ((NodeTree)this.sequence).posLocalName(this.ipos);
    }

    public String getNodeValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getNodeValue(stringBuffer);
        return stringBuffer.toString();
    }

    public void getNodeValue(StringBuffer stringBuffer) {
        NodeTree nodeTree = (NodeTree)this.sequence;
        nodeTree.stringValue(nodeTree.posToDataIndex(this.ipos), stringBuffer);
    }

    public boolean hasChildNodes() {
        return ((NodeTree)this.sequence).posFirstChild(this.ipos) >= 0;
    }

    public String getTextContent() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getTextContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void getTextContent(StringBuffer stringBuffer) {
        this.getNodeValue(stringBuffer);
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getBaseURI() {
        Object object2 = this.sequence.baseUriOfPos(this.ipos);
        return object2 == null ? null : object2.toString();
    }

    public boolean isDefaultNamespace(String string) {
        return ((NodeTree)this.sequence).posIsDefaultNamespace(this.ipos, string);
    }

    public String lookupNamespaceURI(String string) {
        return ((NodeTree)this.sequence).posLookupNamespaceURI(this.ipos, string);
    }

    public String lookupPrefix(String string) {
        return ((NodeTree)this.sequence).posLookupPrefix(this.ipos, string);
    }

    public String toString() {
        CharArrayOutPort charArrayOutPort = new CharArrayOutPort();
        XMLPrinter xMLPrinter = new XMLPrinter(charArrayOutPort);
        ((NodeTree)this.sequence).consumeNext(this.ipos, xMLPrinter);
        return charArrayOutPort.toString();
    }

    public Object getFeature(String string, String string2) {
        return null;
    }
}

