/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Method;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.ThisExp;
import gnu.kawa.reflect.ClassMethodProc;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrongArguments;

public class InlineCalls
extends ExpWalker {
    public static void inlineCalls(Expression expression, Compilation compilation) {
        InlineCalls inlineCalls = new InlineCalls();
        inlineCalls.setContext(compilation);
        inlineCalls.walk(expression);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.comp.inlineOk(applyExp.func)) {
            applyExp = ClassMethodProc.rewrite(applyExp);
        }
        super.walkApplyExp(applyExp);
        LambdaExp lambdaExp = null;
        int n = applyExp.getArgCount();
        if (applyExp.func instanceof LambdaExp) {
            lambdaExp = (LambdaExp)applyExp.func;
        }
        Expression expression = applyExp.func;
        Declaration declaration = null;
        if (expression instanceof ReferenceExp) {
            object5 = (ReferenceExp)expression;
            declaration = ((ReferenceExp)object5).binding;
            if (declaration != null && !declaration.getFlag(65536)) {
                if ((declaration = Declaration.followAliases(declaration)).isIndirectBinding()) {
                    return applyExp;
                }
                expression = declaration.getValue();
                if (expression instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expression;
                }
            } else if (((AccessExp)object5).getSymbol() instanceof Symbol) {
                object4 = (Symbol)((AccessExp)object5).getSymbol();
                object3 = Environment.getCurrent().getFunction((Symbol)object4, null);
                if (object3 instanceof Procedure) {
                    expression = new QuoteExp(object3);
                }
                declaration = null;
            }
        }
        if (expression instanceof QuoteExp && expression != QuoteExp.undefined_exp) {
            object5 = ((QuoteExp)expression).getValue();
            if (!(object5 instanceof Procedure)) {
                return this.noteError(declaration == null || object5 == null ? "called value is not a procedure" : "calling " + declaration.getName() + " which is a " + object5.getClass().getName());
            }
            object4 = (Procedure)object5;
            object3 = WrongArguments.checkArgCount((Procedure)object4, n);
            if (object3 != null) {
                return this.noteError((String)object3);
            }
            if (object4 instanceof CanInline) {
                return ((CanInline)object4).inline(applyExp, this);
            }
            if (applyExp.getFlag(2) && (object2 = applyExp.inlineIfConstant((Procedure)object4, this)) != applyExp) {
                return this.walk((Expression)object2);
            }
            if (this.comp.inlineOk((Procedure)object4)) {
                if (object4 instanceof Inlineable) {
                    return new ApplyExp((Procedure)object4, applyExp.getArgs()).setLine(applyExp);
                }
                object2 = PrimProcedure.getMethodFor((Procedure)object4, declaration, applyExp.args, this.comp.getLanguage());
                if (object2 != null) {
                    ApplyExp applyExp2;
                    if (((PrimProcedure)object2).getStaticFlag() || declaration == null) {
                        applyExp2 = new ApplyExp((Procedure)object2, applyExp.args);
                    } else {
                        if (declaration.base == null) {
                            return applyExp;
                        }
                        Expression[] expressionArray = new Expression[1 + n];
                        System.arraycopy(applyExp.getArgs(), 0, expressionArray, 1, n);
                        expressionArray[0] = new ReferenceExp(declaration.base);
                        applyExp2 = new ApplyExp((Procedure)object2, expressionArray);
                    }
                    return applyExp2.setLine(applyExp);
                }
            }
        }
        if (lambdaExp != null) {
            int n2 = applyExp.args.length;
            object4 = WrongArguments.checkArgCount(lambdaExp.getName(), lambdaExp.min_args, lambdaExp.max_args, n2);
            if (object4 != null) {
                return this.noteError((String)object4);
            }
            int n3 = lambdaExp.getCallConvention();
            if (this.comp.inlineOk(lambdaExp) && lambdaExp.isClassMethod() && (n3 <= 2 || n3 == 3) && (object2 = lambdaExp.getMethod(n2)) != null) {
                Expression expression2;
                Expression[] expressionArray;
                PrimProcedure primProcedure = new PrimProcedure((Method)object2, lambdaExp);
                if (primProcedure.getStaticFlag()) {
                    expressionArray = applyExp.args;
                } else {
                    expression2 = this.getCurrentLambda();
                    while (true) {
                        if (expression2 == null) {
                            return this.noteError("internal error: missing " + lambdaExp);
                        }
                        if (((LambdaExp)expression2).outer == lambdaExp.outer) break;
                        expression2 = ((LambdaExp)expression2).outerLambda();
                    }
                    Declaration declaration2 = ((ScopeExp)expression2).firstDecl();
                    if (declaration2 == null || !declaration2.isThisParameter()) {
                        return this.noteError("calling non-static method " + lambdaExp.getName() + " from static method " + expression2.getName());
                    }
                    expressionArray = new Expression[1 + n];
                    System.arraycopy(applyExp.getArgs(), 0, expressionArray, 1, n);
                    expressionArray[0] = new ThisExp(declaration2);
                }
                expression2 = new ApplyExp(primProcedure, expressionArray);
                return expression2.setLine(applyExp);
            }
        }
        return applyExp;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Expression expression;
        Declaration declaration = referenceExp.getBinding();
        if (declaration != null && declaration.getFlag(16384) && declaration.field == null && (expression = declaration.getValue()) instanceof QuoteExp && expression != QuoteExp.undefined_exp) {
            return this.walkQuoteExp((QuoteExp)expression);
        }
        return super.walkReferenceExp(referenceExp);
    }

    protected Expression walkIfExp(IfExp ifExp) {
        ifExp.walkChildren(this);
        Expression expression = ifExp.test;
        if (expression instanceof QuoteExp) {
            Language language = this.comp.getLanguage();
            if (language.isTrue(((QuoteExp)expression).getValue())) {
                return ifExp.then_clause;
            }
            return ifExp.else_clause == null ? QuoteExp.voidExp : ifExp.else_clause;
        }
        return ifExp;
    }

    protected Expression walkLetExp(LetExp letExp) {
        Declaration declaration = letExp.firstDecl();
        int n = 0;
        while (n < letExp.inits.length) {
            Expression expression;
            Expression expression2 = letExp.inits[n];
            letExp.inits[n] = expression = this.walk(expression2);
            Expression expression3 = declaration.value;
            if (expression3 == expression2) {
                declaration.value = expression3 = expression;
                if (!declaration.getFlag(8192)) {
                    declaration.setType(expression3.getType());
                }
            }
            ++n;
            declaration = declaration.nextDecl();
        }
        if (this.exitValue == null) {
            letExp.body = this.walk(letExp.body);
        }
        return letExp;
    }

    protected Expression walkClassExp(ClassExp classExp) {
        classExp.setParts(this, this.comp);
        this.comp.addClass(classExp.type);
        if (classExp.isMakingClassPair()) {
            classExp.instanceType.setName(classExp.type.getName() + "$class");
            this.comp.addClass(classExp.instanceType);
        }
        return super.walkClassExp(classExp);
    }
}

