/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.SourceMessages;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.lang.Macro;

public class ModuleExp
extends LambdaExp {
    public boolean mustCompile;
    public static boolean debugPrintExpr = false;
    public static final int EXPORT_SPECIFIED = 2048;
    public static final int STATIC_SPECIFIED = 4096;
    public static final int NONSTATIC_SPECIFIED = 8192;
    public static final int SUPERTYPE_SPECIFIED = 16384;
    public static String dumpZipPrefix;
    public static int dumpZipCounter;
    ClassType superType;
    ClassType[] interfaces;

    public String getJavaName() {
        return this.name == null ? "lambda" : Compilation.mangleName(this.name);
    }

    public static Class evalToClass(Compilation compilation) {
        ModuleExp moduleExp = compilation.getModule();
        SourceMessages sourceMessages = compilation.getMessages();
        try {
            Object object2;
            Object object3;
            ArrayClassLoader arrayClassLoader;
            String string = moduleExp.getJavaName();
            compilation.immediate = true;
            compilation.loader = arrayClassLoader = new ArrayClassLoader();
            compilation.compile(moduleExp, string, null);
            if (sourceMessages.seenErrors()) {
                return null;
            }
            byte[][] byArrayArray = new byte[compilation.numClasses][];
            ZipOutputStream zipOutputStream = null;
            if (dumpZipPrefix != null) {
                StringBuffer stringBuffer = new StringBuffer(dumpZipPrefix);
                if (dumpZipCounter >= 0) {
                    stringBuffer.append(++dumpZipCounter);
                }
                stringBuffer.append(".zip");
                object3 = new FileOutputStream(stringBuffer.toString());
                zipOutputStream = new ZipOutputStream((OutputStream)object3);
            }
            int n = 0;
            while (n < compilation.numClasses) {
                object3 = compilation.classes[n];
                object2 = ((Type)object3).getName();
                byte[] byArray = ((ClassType)object3).writeToArray();
                arrayClassLoader.addClass((String)object2, byArray);
                if (zipOutputStream != null) {
                    String string2 = ((String)object2).replace('.', '/') + ".class";
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipEntry.setSize(byArray.length);
                    CRC32 cRC32 = new CRC32();
                    cRC32.update(byArray);
                    zipEntry.setCrc(cRC32.getValue());
                    zipEntry.setMethod(0);
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(byArray);
                }
                ++n;
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            object3 = arrayClassLoader.loadClass(string, true);
            object2 = compilation.litTable.literalsChain;
            while (object2 != null) {
                try {
                    ((Class)object3).getDeclaredField(((Literal)object2).field.getName()).set(null, ((Literal)object2).value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new Error("internal error - " + noSuchFieldException);
                }
                object2 = ((Literal)object2).next;
            }
            return object3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(OutPort.errDefault());
            throw new RuntimeException("I/O error in lambda eval: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("class not found in lambda eval");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void evalModule(Environment environment, CallContext callContext, Compilation compilation) throws Throwable {
        Environment environment2;
        block12: {
            block11: {
                ModuleExp moduleExp = compilation.getModule();
                environment2 = Environment.getCurrent();
                try {
                    Object object2;
                    if (environment != environment2) {
                        Environment.setCurrent(environment);
                    }
                    if (debugPrintExpr) {
                        object2 = OutPort.outDefault();
                        ((PrintWriter)object2).println("[Evaluating module \"" + moduleExp.getName() + "\" mustCompile=" + moduleExp.mustCompile + ':');
                        moduleExp.print((OutPort)object2);
                        ((PrintWriter)object2).println(']');
                        ((PrintWriter)object2).flush();
                    }
                    if (!moduleExp.mustCompile) {
                        moduleExp.body.eval(environment, callContext);
                    } else {
                        try {
                            Class clazz = ModuleExp.evalToClass(compilation);
                            if (clazz == null) {
                                Object var10_8 = null;
                                if (environment == environment2) return;
                                break block11;
                            }
                            Object t = clazz.newInstance();
                            Procedure procedure = (Procedure)t;
                            if (procedure.getName() == null) {
                                procedure.setName(moduleExp.name);
                            }
                            object2 = (ModuleBody)t;
                        }
                        catch (InstantiationException instantiationException) {
                            throw new RuntimeException("class not instantiable: in lambda eval");
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new RuntimeException("class illegal access: in lambda eval");
                        }
                        ClassMemberConstraint.defineAll(object2, environment);
                        callContext.proc = object2;
                    }
                    callContext.runUntilDone();
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (environment == environment2) throw throwable;
                    Environment.setCurrent(environment2);
                    throw throwable;
                }
            }
            Environment.setCurrent(environment2);
            return;
        }
        Object var10_9 = null;
        if (environment == environment2) return;
        Environment.setCurrent(environment2);
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType classType) {
        this.superType = classType;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public final boolean isStatic() {
        return this.getFlag(4096) || Compilation.moduleStatic > 0 && !this.getFlag(16384) && !this.getFlag(8192);
    }

    void allocFields(Compilation compilation) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if ((!declaration.isSimple() || declaration.isPublic()) && declaration.field == null && declaration.getFlag(65536)) {
                declaration.makeField(compilation, null);
            }
            declaration = declaration.nextDecl();
        }
        Declaration declaration2 = this.firstDecl();
        while (declaration2 != null) {
            if (declaration2.field == null) {
                Expression expression = declaration2.getValue();
                if (!((declaration2.isSimple() && !declaration2.isPublic() || declaration2.ignorable()) && !(expression instanceof ClassExp) || declaration2.getFlag(65536) || declaration2.getFlag(32768) && ((Macro)declaration2.getConstantValue()).expander instanceof LambdaExp && !declaration2.isPrivate())) {
                    if (expression instanceof LambdaExp && !(expression instanceof ClassExp)) {
                        ((LambdaExp)expression).allocFieldFor(compilation);
                    } else {
                        if (!declaration2.getFlag(16640) || expression == QuoteExp.undefined_exp) {
                            expression = null;
                        }
                        declaration2.makeField(compilation, expression);
                    }
                }
            }
            declaration2 = declaration2.nextDecl();
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkModuleExp(this);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Module/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.writeSpaceFill();
        outPort.startLogicalBlock("(", false, ")");
        Declaration declaration = this.firstDecl();
        if (declaration != null) {
            outPort.print("Declarations:");
            while (declaration != null) {
                outPort.writeSpaceFill();
                declaration.printInfo(outPort);
                declaration = declaration.nextDecl();
            }
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

