/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.ScopeExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;
import java.util.Stack;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class let
extends Syntax {
    public static final let let = new let("let", false);
    protected boolean settingProcedures;

    public let(String name, boolean settingProcedures) {
        this.setName(name);
        this.settingProcedures = settingProcedures;
    }

    public Expression rewrite(Object obj, Translator tr) {
        int i;
        if (!(obj instanceof Pair)) {
            return tr.syntaxError("missing " + this.getName() + " arguments");
        }
        Pair pair = (Pair)obj;
        Object bindings = pair.getCar();
        Object body = pair.getCdr();
        int decl_count = Translator.listLength(bindings);
        if (decl_count < 0) {
            return tr.syntaxError("bindings not a proper list");
        }
        Expression[] inits = new Expression[decl_count];
        Declaration[] decls = new Declaration[decl_count];
        SimpleEnvironment dupenv = new SimpleEnvironment();
        Stack<Declaration> renamedAliases = null;
        int renamedAliasesCount = 0;
        SyntaxForm syntaxRest = null;
        for (i = 0; i < decl_count; ++i) {
            Pair init;
            TemplateScope templateScope;
            while (bindings instanceof SyntaxForm) {
                syntaxRest = (SyntaxForm)bindings;
                bindings = syntaxRest.getDatum();
            }
            Pair bind_pair = (Pair)bindings;
            Object bind_pair_car = bind_pair.getCar();
            SyntaxForm syntax2 = syntaxRest;
            if (bind_pair_car instanceof SyntaxForm) {
                syntax2 = (SyntaxForm)bind_pair_car;
                bind_pair_car = syntax2.getDatum();
            }
            if (!(bind_pair_car instanceof Pair)) {
                return tr.syntaxError(this.getName() + " binding is not a pair:" + bind_pair_car);
            }
            Pair binding = (Pair)bind_pair_car;
            Object name = binding.getCar();
            if (name instanceof SyntaxForm) {
                SyntaxForm sf = (SyntaxForm)name;
                name = sf.getDatum();
                templateScope = sf.getScope();
            } else {
                templateScope = syntax2 == null ? null : syntax2.getScope();
            }
            name = tr.namespaceResolve(name);
            if (!(name instanceof Symbol)) {
                return tr.syntaxError("variable " + name + " in " + this.getName() + " binding is not a symbol: " + obj);
            }
            Declaration decl = new Declaration(name);
            Translator.setLine(decl, (Object)binding);
            Symbol sym = (Symbol)name;
            Object old = dupenv.get(sym, templateScope, null);
            if (old != null) {
                ScopeExp.duplicateDeclarationError((Declaration)old, decl, tr);
            }
            dupenv.put(sym, templateScope, decl);
            decls[i] = decl;
            decl.setFlag(262144L);
            this.maybeSetProcedure(decl);
            if (templateScope != null) {
                Declaration alias = tr.makeRenamedAlias(decl, templateScope);
                if (renamedAliases == null) {
                    renamedAliases = new Stack<Declaration>();
                }
                renamedAliases.push(alias);
                ++renamedAliasesCount;
            }
            Object binding_cdr = binding.getCdr();
            while (binding_cdr instanceof SyntaxForm) {
                syntax2 = (SyntaxForm)binding_cdr;
                binding_cdr = syntax2.getDatum();
            }
            if (!(binding_cdr instanceof Pair)) {
                return tr.syntaxError(this.getName() + " has no value for '" + name + "'");
            }
            binding = (Pair)binding_cdr;
            binding_cdr = binding.getCdr();
            while (binding_cdr instanceof SyntaxForm) {
                syntax2 = (SyntaxForm)binding_cdr;
                binding_cdr = syntax2.getDatum();
            }
            if (tr.matches(binding.getCar(), "::")) {
                if (!(binding_cdr instanceof Pair) || (binding = (Pair)binding_cdr).getCdr() == LList.Empty) {
                    return tr.syntaxError("missing type after '::' in " + this.getName());
                }
                binding_cdr = binding.getCdr();
                while (binding_cdr instanceof SyntaxForm) {
                    syntax2 = (SyntaxForm)binding_cdr;
                    binding_cdr = syntax2.getDatum();
                }
            }
            if (binding_cdr == LList.Empty) {
                init = binding;
            } else if (binding_cdr instanceof Pair) {
                decl.setType(tr.exp2Type(binding, null, syntax2));
                decl.setFlag(8192L);
                init = (Pair)binding_cdr;
            } else {
                return tr.syntaxError(this.getName() + " binding for '" + this.getName() + "' is improper list");
            }
            inits[i] = tr.rewrite_car(init, syntax2);
            if (init.getCdr() != LList.Empty) {
                return tr.syntaxError("junk after declaration of " + this.getName());
            }
            bindings = bind_pair.getCdr();
        }
        i = renamedAliasesCount;
        while (--i >= 0) {
            tr.pushRenamedAlias((Declaration)renamedAliases.pop());
        }
        tr.letStart();
        for (i = 0; i < decl_count; ++i) {
            tr.letVariable(decls[i], inits[i]);
        }
        tr.letEnter();
        LetExp let2 = tr.letDone(tr.rewrite_body(body));
        tr.popRenamedAlias(renamedAliasesCount);
        return let2;
    }

    protected void maybeSetProcedure(Declaration decl) {
        if (this.settingProcedures) {
            decl.setProcedureDecl(true);
        }
    }
}

