/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.cmosPLA;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.cmosPLA.IO;
import com.sun.electric.tool.generator.cmosPLA.PLA;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class NGrid {
    private PLA pla;
    private EditingPreferences ep;

    NGrid(PLA pla, EditingPreferences ep) {
        this.pla = pla;
        this.ep = ep;
    }

    Cell nmosGrid(Library library, String fileName, String cellName) {
        int y = 0;
        int x = 3;
        int xOffset = 10;
        int yOffset = 10;
        int yMOffset = 10;
        Cell cell = Cell.makeInstance(this.ep, library, cellName);
        IO perFile = new IO();
        if (!perFile.readHeader(fileName)) {
            System.out.println("Error reading height and width");
            return null;
        }
        int width = perFile.getWidth();
        int height = perFile.getHeight();
        int widthIn = perFile.getWidthIn();
        int heightIn = perFile.getHeightIn();
        cell.newVar("PLA_data_cols", (Object)widthIn, this.ep);
        cell.newVar("PLA_access_rows", (Object)heightIn, this.ep);
        cell.newVar("PLA_cols", (Object)width, this.ep);
        cell.newVar("PLA_rows", (Object)height, this.ep);
        if (this.nmosInitColumns(width, x, y, xOffset, cell)) {
            return null;
        }
        if (this.nmosInitRows(heightIn, x, y, yOffset, yMOffset, cell)) {
            return null;
        }
        y = -1 - yOffset;
        x = xOffset;
        int row = 0;
        int readRows = 0;
        while (readRows < heightIn) {
            int[] row1 = null;
            int[] row2 = null;
            if (readRows < heightIn) {
                row1 = perFile.readRow();
                if (row1 == null) {
                    return null;
                }
                ++readRows;
            }
            if (readRows < heightIn) {
                row2 = perFile.readRow();
                if (row2 == null) {
                    return null;
                }
                ++readRows;
            }
            for (int i = 0; i < width; ++i) {
                if (i % 5 == 0 && i != 0) {
                    if (!this.gndStrap(i, xOffset * i + 3, y, row, cell)) continue;
                    return null;
                }
                if (row1[i] == 1 && this.nmosMakeOne(i, i * xOffset, y, false, row, cell)) {
                    return null;
                }
                if (row2[i] != 1 || !this.nmosMakeOne(i, i * xOffset, y - yMOffset, true, row, cell)) continue;
                return null;
            }
            if (this.completeRow(row, xOffset * width, y, cell)) {
                return null;
            }
            if (readRows % 4 == 0) {
                y -= yOffset;
            }
            ++row;
            y -= 2 * yOffset;
        }
        x = 3;
        y = readRows % 4 == 0 ? (y += 2 * yOffset) : (y += yOffset);
        if (this.finishColumns(width, x, y, xOffset, cell)) {
            return null;
        }
        ERectangle cellBounds = cell.getBounds();
        NodeInst.makeInstance(this.pla.pwNode, this.ep, new Point2D.Double(((RectangularShape)cellBounds).getCenterX(), ((RectangularShape)cellBounds).getCenterY()), ((RectangularShape)cellBounds).getWidth(), ((RectangularShape)cellBounds).getHeight(), cell);
        perFile.done();
        return cell;
    }

    private boolean gndStrap(int i, int x, int y, int row, Cell arrayCell) {
        PLA.UCItem newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y + 11, 14.0, this.pla.mwBut);
        if (newItem.nodeInst == null) {
            return true;
        }
        PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
        PortProto lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = newItem;
        newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y + 1, 14.0, this.pla.maCon);
        if (newItem.nodeInst == null) {
            return true;
        }
        nodeColPort = newItem.nodeInst.getProto().getPort(0);
        lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        lastColPort = this.pla.rowList[row][1].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.rowList[row][1].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][1].lastitem.nodeInst.getProto().findPortProto("GND.d.s");
        this.pla.makeWire(this.pla.aArc, 3.0, this.pla.rowList[row][1].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = newItem;
        this.pla.rowList[row][1].lastitem = this.pla.rowList[row][1].lastitem.rightItem = newItem;
        return false;
    }

    private boolean nmosMakeOne(int i, int x, int y, boolean mirror, int row, Cell arrayCell) {
        NodeInst ni;
        int rowPos = 0;
        if (mirror) {
            rowPos = 2;
        }
        if ((ni = this.pla.makeInstance(arrayCell, this.pla.nmosOne, x, y, mirror)) == null) {
            return true;
        }
        PortProto nodeColPort = ni.getProto().findPortProto("OUT.m-1.n");
        PortProto lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.columnList[i].firstItem.nodeInst.getProto().getPort(0) : this.pla.columnList[i].lastitem.nodeInst.getProto().findPortProto("OUT.m-1.n");
        this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, ni, nodeColPort, arrayCell);
        if (this.pla.rowList[row][1].lastitem == null) {
            System.out.println("No UCITEM at row " + row);
            return true;
        }
        if (this.pla.rowList[row][1].lastitem.nodeInst == null) {
            System.out.println("No NODEINST at row 1 " + row);
            return true;
        }
        lastColPort = this.pla.rowList[row][1].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.rowList[row][1].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][1].lastitem.nodeInst.getProto().findPortProto("GND.d.s");
        if (lastColPort == null) {
            System.out.println("No NODEPROTO for GND.d.s");
            return true;
        }
        nodeColPort = ni.getProto().findPortProto("GND.d.s");
        this.pla.makeWire(this.pla.aArc, 3.0, this.pla.rowList[row][1].lastitem.nodeInst, lastColPort, ni, nodeColPort, arrayCell);
        lastColPort = this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        nodeColPort = ni.getProto().findPortProto("GATE.p.w");
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][rowPos].lastitem.nodeInst, lastColPort, ni, nodeColPort, arrayCell);
        this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = new PLA.UCItem();
        this.pla.columnList[i].lastitem.nodeInst = ni;
        this.pla.rowList[row][rowPos].lastitem = this.pla.rowList[row][1].lastitem = (this.pla.rowList[row][1].lastitem.rightItem = this.pla.columnList[i].lastitem);
        return false;
    }

    private boolean completeRow(int row, int x, int y, Cell arrayCell) {
        PLA.UCItem newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y + 6, 6.0, this.pla.mpCon);
        if (newItem.nodeInst == null) {
            return true;
        }
        PortProto lastColPort = this.pla.rowList[row][0].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][0].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][0].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.rowList[row][0].lastitem = newItem;
        PortProto pp = this.pla.rowList[row][0].firstItem.nodeInst.getProto().getPort(0);
        PortInst pi = this.pla.rowList[row][0].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + row * 2 + ".m-1.w", this.ep);
        pp = this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + row * 2 + ".m-1.e", this.ep);
        pp = this.pla.rowList[row][0].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + row * 2 + ".p.w", this.ep);
        pp = this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + row * 2 + ".p.e", this.ep);
        newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y - 4, 6.0, this.pla.mpCon);
        if (newItem.nodeInst == null) {
            return true;
        }
        lastColPort = this.pla.rowList[row][2].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][2].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        nodeColPort = newItem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][2].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.rowList[row][2].lastitem = newItem;
        pp = this.pla.rowList[row][2].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".m-1.w", this.ep);
        pp = this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".m-1.e", this.ep);
        pp = this.pla.rowList[row][2].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".p.w", this.ep);
        pp = this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInst(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".p.e", this.ep);
        return false;
    }

    private boolean nmosInitColumns(int width, int x, int y, int xOffset, Cell arrayCell) {
        int gndCnt = 0;
        for (int i = 0; i < width; ++i) {
            String name;
            this.pla.columnList[i].lastitem = this.pla.columnList[i].firstItem = new PLA.UCItem();
            if (i % 5 == 0) {
                name = "GND" + gndCnt + ".m-1.n";
                this.pla.columnList[i].firstItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 14.0, this.pla.mwBut);
                if (this.pla.columnList[i].firstItem.nodeInst == null) {
                    return true;
                }
                ++gndCnt;
            } else {
                name = "DATA" + (i - gndCnt) + ".m-1.n";
                this.pla.columnList[i].firstItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 4.0, this.pla.m1Pin);
                if (this.pla.columnList[i].firstItem.nodeInst == null) {
                    return true;
                }
            }
            PortProto pp = this.pla.columnList[i].firstItem.nodeInst.getProto().getPort(0);
            PortInst pi = this.pla.columnList[i].firstItem.nodeInst.findPortInstFromProto(pp);
            Export.newInst(arrayCell, pi, name, this.ep);
        }
        return false;
    }

    private boolean nmosInitRows(int heightIn, int x, int y, int yOffset, int yMOffset, Cell arrayCell) {
        int limit = heightIn / 2 + heightIn % 2;
        for (int i = 0; i < limit; ++i) {
            if (i % 2 == 0 && i != 0) {
                y -= yOffset;
            }
            PLA.UCItem newItem = new PLA.UCItem();
            newItem.nodeInst = this.pla.makePin(arrayCell, x, y - yMOffset + 10, 14.0, this.pla.mwBut);
            if (newItem.nodeInst == null) {
                return true;
            }
            PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
            PortProto lastColPort = this.pla.columnList[0].lastitem.nodeInst.getProto().getPort(0);
            this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[0].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
            this.pla.columnList[0].lastitem = this.pla.columnList[0].lastitem.bottomItem = newItem;
            this.pla.rowList[i][0].lastitem = this.pla.rowList[i][0].firstItem = new PLA.UCItem();
            this.pla.rowList[i][1].lastitem = this.pla.rowList[i][1].firstItem = new PLA.UCItem();
            this.pla.rowList[i][2].lastitem = this.pla.rowList[i][2].firstItem = new PLA.UCItem();
            this.pla.rowList[i][0].firstItem.nodeInst = this.pla.makePin(arrayCell, x - 7, y - 5, 6.0, this.pla.mpCon);
            if (this.pla.rowList[i][0].firstItem.nodeInst == null) {
                return true;
            }
            this.pla.rowList[i][1].firstItem.nodeInst = this.pla.makePin(arrayCell, x, y - yMOffset, 14.0, this.pla.maCon);
            if (this.pla.rowList[i][1].firstItem.nodeInst == null) {
                return true;
            }
            this.pla.rowList[i][2].firstItem.nodeInst = this.pla.makePin(arrayCell, x - 7, y - 15, 6.0, this.pla.mpCon);
            if (this.pla.rowList[i][2].firstItem.nodeInst == null) {
                return true;
            }
            nodeColPort = this.pla.rowList[i][1].firstItem.nodeInst.getProto().getPort(0);
            lastColPort = this.pla.columnList[0].lastitem.nodeInst.getProto().getPort(0);
            this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[0].lastitem.nodeInst, lastColPort, this.pla.rowList[i][1].lastitem.nodeInst, nodeColPort, arrayCell);
            this.pla.columnList[0].lastitem = this.pla.columnList[0].lastitem.bottomItem = this.pla.rowList[i][1].lastitem;
            y -= 2 * yOffset;
        }
        return false;
    }

    private boolean finishColumns(int width, int x, int y, int xOffset, Cell arrayCell) {
        int gndCnt = 0;
        for (int i = 0; i < width; ++i) {
            PortProto lastColPort;
            String name;
            PLA.UCItem newItem = new PLA.UCItem();
            if (i % 5 == 0) {
                name = "GND" + gndCnt + ".m-1.s";
                newItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 14.0, this.pla.mwBut);
                if (newItem.nodeInst == null) {
                    return true;
                }
                lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0);
                ++gndCnt;
            } else {
                name = "DATA" + (i - gndCnt) + ".m-1.s";
                newItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 4.0, this.pla.m1Pin);
                if (newItem.nodeInst == null) {
                    return true;
                }
                lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto() != this.pla.nmosOne ? this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0) : this.pla.columnList[i].lastitem.nodeInst.getProto().findPortProto("OUT.m-1.n");
            }
            PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
            this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
            this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = newItem;
            PortInst pi = newItem.nodeInst.findPortInstFromProto(newItem.nodeInst.getProto().getPort(0));
            Export.newInst(arrayCell, pi, name, this.ep);
        }
        return false;
    }
}

