/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.PageStorage;

public class OverflowPageStorage
extends PageStorage {
    private final PageStorage ps1;
    private final PageStorage ps2;
    private final int highWaterMark;
    private boolean overflowed = false;

    public OverflowPageStorage(PageStorage ps1, PageStorage ps2, long highWaterMark) {
        super(Math.max(ps1.getPageSize(), ps1.getPageSize()));
        this.ps1 = ps1;
        this.ps2 = ps2;
        this.highWaterMark = (int)(highWaterMark / (long)this.getPageSize());
    }

    @Override
    public int getNumPages() {
        return this.overflowed ? this.ps2.getNumPages() : this.ps1.getNumPages();
    }

    @Override
    public synchronized int createPage() {
        if (this.overflowed) {
            return this.ps2.createPage();
        }
        if (this.ps1.getNumPages() < this.highWaterMark) {
            return this.ps1.createPage();
        }
        byte[] buf = new byte[this.getPageSize()];
        for (int i = 0; i < this.ps1.getNumPages(); ++i) {
            while (this.ps2.getNumPages() < i + 1) {
                this.ps2.createPage();
            }
            this.ps1.readPage(i, buf, 0);
            this.ps2.writePage(i, buf, 0);
        }
        this.overflowed = true;
        this.ps1.close();
        return this.ps2.createPage();
    }

    @Override
    public void fsync(int pageid) {
        if (this.overflowed) {
            this.ps2.fsync(pageid);
        } else {
            this.ps1.fsync(pageid);
        }
    }

    @Override
    public void writePage(int pageid, byte[] buf, int ofs) {
        if (this.overflowed) {
            this.ps2.writePage(pageid, buf, ofs);
        } else {
            this.ps1.writePage(pageid, buf, ofs);
        }
    }

    @Override
    public void readPage(int pageid, byte[] buf, int ofs) {
        if (this.overflowed) {
            this.ps2.readPage(pageid, buf, ofs);
        } else {
            this.ps1.readPage(pageid, buf, ofs);
        }
    }

    @Override
    public synchronized void close() {
        if (this.overflowed) {
            this.ps2.close();
        } else {
            this.ps1.close();
        }
    }
}

