/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.sun.electric.Main;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.HelpMenu;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class MacOSXInterface
extends ApplicationAdapter {
    private static MacOSXInterface adapter = null;
    private static Application application = null;
    private static List<String> argsList;
    protected Job initJob;

    private MacOSXInterface(List<String> list) {
        argsList = list;
    }

    public static void setInitJob(Job ij) {
        MacOSXInterface.adapter.initJob = ij;
    }

    public void handleAbout(ApplicationEvent ae) {
        ae.setHandled(true);
        HelpMenu.aboutCommand();
    }

    public void handlePreferences(ApplicationEvent ae) {
        ae.setHandled(true);
        PreferencesFrame.preferencesCommand();
    }

    public void handleQuit(ApplicationEvent ae) {
        ae.setHandled(false);
        FileMenu.quitCommand();
    }

    public void handleOpenFile(ApplicationEvent ae) {
        ae.setHandled(true);
        String filename = ae.getFilename();
        if (!UserInterfaceMain.initializationFinished) {
            argsList.add(filename);
        } else {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(filename);
            Main.openCommandLineLibs(list);
        }
        URL dirUrl = TextUtils.makeURLToFile(filename);
        String dirString = TextUtils.getFilePath(dirUrl);
        User.setWorkingDirectory(dirString);
    }

    public static void registerMacOSXApplication(List<String> argsList) {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Electric");
        if (application == null) {
            application = new Application();
        }
        if (adapter == null) {
            adapter = new MacOSXInterface(argsList);
        }
        application.addApplicationListener((ApplicationListener)adapter);
        application.setEnabledPreferencesMenu(true);
    }
}

