# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

import bpy


def create(obj):
    # generated by rigify.utils.write_metarig
    bpy.ops.object.mode_set(mode='EDIT')
    arm = obj.data

    for i in range(28):
        arm.rigify_layers.add()

    arm.rigify_layers[0].name = "Torso"
    arm.rigify_layers[0].row = 2
    arm.rigify_layers[2].name = "Head"
    arm.rigify_layers[2].row = 1
    arm.rigify_layers[4].name = "Fingers"
    arm.rigify_layers[4].row = 3
    arm.rigify_layers[5].name = "(Tweak)"
    arm.rigify_layers[5].row = 3
    arm.rigify_layers[6].name = "Arm.L (FK)"
    arm.rigify_layers[6].row = 4
    arm.rigify_layers[7].name = "Arm.L (IK)"
    arm.rigify_layers[7].row = 5
    arm.rigify_layers[8].name = "Arm.R (FK)"
    arm.rigify_layers[8].row = 4
    arm.rigify_layers[9].name = "Arm.R (IK)"
    arm.rigify_layers[9].row = 5
    arm.rigify_layers[10].name = "Leg.L (FK)"
    arm.rigify_layers[10].row = 6
    arm.rigify_layers[11].name = "Leg.L (IK)"
    arm.rigify_layers[11].row = 7
    arm.rigify_layers[12].name = "Leg.R (FK)"
    arm.rigify_layers[12].row = 6
    arm.rigify_layers[13].name = "Leg.R (IK)"
    arm.rigify_layers[13].row = 7

    bones = {}

    bone = arm.edit_bones.new('hips')
    bone.head[:] = 0.0000, 0.0552, 1.0099
    bone.tail[:] = 0.0000, 0.0172, 1.1837
    bone.roll = 0.0000
    bone.use_connect = False
    bones['hips'] = bone.name
    bone = arm.edit_bones.new('spine')
    bone.head[:] = 0.0000, 0.0172, 1.1837
    bone.tail[:] = 0.0000, 0.0004, 1.3418
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['hips']]
    bones['spine'] = bone.name
    bone = arm.edit_bones.new('thigh.L')
    bone.head[:] = 0.0980, 0.0124, 1.0720
    bone.tail[:] = 0.0980, -0.0286, 0.5372
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hips']]
    bones['thigh.L'] = bone.name
    bone = arm.edit_bones.new('thigh.R')
    bone.head[:] = -0.0980, 0.0124, 1.0720
    bone.tail[:] = -0.0980, -0.0286, 0.5372
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hips']]
    bones['thigh.R'] = bone.name
    bone = arm.edit_bones.new('ribs')
    bone.head[:] = 0.0000, 0.0004, 1.3418
    bone.tail[:] = 0.0000, 0.0114, 1.6582
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine']]
    bones['ribs'] = bone.name
    bone = arm.edit_bones.new('shin.L')
    bone.head[:] = 0.0980, -0.0286, 0.5372
    bone.tail[:] = 0.0980, 0.0162, 0.0852
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.L']]
    bones['shin.L'] = bone.name
    bone = arm.edit_bones.new('shin.R')
    bone.head[:] = -0.0980, -0.0286, 0.5372
    bone.tail[:] = -0.0980, 0.0162, 0.0852
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.R']]
    bones['shin.R'] = bone.name
    bone = arm.edit_bones.new('neck')
    bone.head[:] = 0.0000, 0.0114, 1.6582
    bone.tail[:] = 0.0000, -0.0247, 1.7813
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['ribs']]
    bones['neck'] = bone.name
    bone = arm.edit_bones.new('shoulder.L')
    bone.head[:] = 0.0183, -0.0684, 1.6051
    bone.tail[:] = 0.1694, 0.0205, 1.6050
    bone.roll = 0.0004
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['ribs']]
    bones['shoulder.L'] = bone.name
    bone = arm.edit_bones.new('shoulder.R')
    bone.head[:] = -0.0183, -0.0684, 1.6051
    bone.tail[:] = -0.1694, 0.0205, 1.6050
    bone.roll = -0.0004
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['ribs']]
    bones['shoulder.R'] = bone.name
    bone = arm.edit_bones.new('foot.L')
    bone.head[:] = 0.0980, 0.0162, 0.0852
    bone.tail[:] = 0.0980, -0.0934, 0.0167
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.L']]
    bones['foot.L'] = bone.name
    bone = arm.edit_bones.new('heel.L')
    bone.head[:] = 0.0980, 0.0162, 0.0852
    bone.tail[:] = 0.0980, 0.0882, -0.0000
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.L']]
    bones['heel.L'] = bone.name
    bone = arm.edit_bones.new('heel.02.L')
    bone.head[:] = 0.0600, 0.0000, 0.0000
    bone.tail[:] = 0.1400, 0.0000, 0.0000
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['heel.L']]
    bones['heel.02.L'] = bone.name
    bone = arm.edit_bones.new('foot.R')
    bone.head[:] = -0.0980, 0.0162, 0.0852
    bone.tail[:] = -0.0980, -0.0934, 0.0167
    bone.roll = -0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.R']]
    bones['foot.R'] = bone.name
    bone = arm.edit_bones.new('heel.R')
    bone.head[:] = -0.0980, 0.0162, 0.0852
    bone.tail[:] = -0.0980, 0.0882, -0.0000
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.R']]
    bones['heel.R'] = bone.name
    bone = arm.edit_bones.new('heel.02.R')
    bone.head[:] = -0.0600, 0.0000, 0.0000
    bone.tail[:] = -0.1400, 0.0000, 0.0000
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['heel.R']]
    bones['heel.02.R'] = bone.name
    bone = arm.edit_bones.new('head')
    bone.head[:] = 0.0000, -0.0247, 1.7813
    bone.tail[:] = 0.0000, -0.0247, 1.9347
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['neck']]
    bones['head'] = bone.name
    bone = arm.edit_bones.new('upper_arm.L')
    bone.head[:] = 0.1953, 0.0267, 1.5846
    bone.tail[:] = 0.4424, 0.0885, 1.4491
    bone.roll = 2.0691
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.L']]
    bones['upper_arm.L'] = bone.name
    bone = arm.edit_bones.new('upper_arm.R')
    bone.head[:] = -0.1953, 0.0267, 1.5846
    bone.tail[:] = -0.4424, 0.0885, 1.4491
    bone.roll = -2.0691
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.R']]
    bones['upper_arm.R'] = bone.name
    bone = arm.edit_bones.new('toe.L')
    bone.head[:] = 0.0980, -0.0934, 0.0167
    bone.tail[:] = 0.0980, -0.1606, 0.0167
    bone.roll = -0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.L']]
    bones['toe.L'] = bone.name
    bone = arm.edit_bones.new('toe.R')
    bone.head[:] = -0.0980, -0.0934, 0.0167
    bone.tail[:] = -0.0980, -0.1606, 0.0167
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.R']]
    bones['toe.R'] = bone.name
    bone = arm.edit_bones.new('forearm.L')
    bone.head[:] = 0.4424, 0.0885, 1.4491
    bone.tail[:] = 0.6594, 0.0492, 1.3061
    bone.roll = 2.1459
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['upper_arm.L']]
    bones['forearm.L'] = bone.name
    bone = arm.edit_bones.new('forearm.R')
    bone.head[:] = -0.4424, 0.0885, 1.4491
    bone.tail[:] = -0.6594, 0.0492, 1.3061
    bone.roll = -2.1459
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['upper_arm.R']]
    bones['forearm.R'] = bone.name
    bone = arm.edit_bones.new('hand.L')
    bone.head[:] = 0.6594, 0.0492, 1.3061
    bone.tail[:] = 0.7234, 0.0412, 1.2585
    bone.roll = -2.4946
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['forearm.L']]
    bones['hand.L'] = bone.name
    bone = arm.edit_bones.new('hand.R')
    bone.head[:] = -0.6594, 0.0492, 1.3061
    bone.tail[:] = -0.7234, 0.0412, 1.2585
    bone.roll = 2.4946
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['forearm.R']]
    bones['hand.R'] = bone.name
    bone = arm.edit_bones.new('palm.01.L')
    bone.head[:] = 0.6921, 0.0224, 1.2882
    bone.tail[:] = 0.7464, 0.0051, 1.2482
    bone.roll = -2.4928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.L']]
    bones['palm.01.L'] = bone.name
    bone = arm.edit_bones.new('palm.02.L')
    bone.head[:] = 0.6970, 0.0389, 1.2877
    bone.tail[:] = 0.7518, 0.0277, 1.2487
    bone.roll = -2.5274
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.L']]
    bones['palm.02.L'] = bone.name
    bone = arm.edit_bones.new('palm.03.L')
    bone.head[:] = 0.6963, 0.0545, 1.2874
    bone.tail[:] = 0.7540, 0.0521, 1.2482
    bone.roll = -2.5843
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.L']]
    bones['palm.03.L'] = bone.name
    bone = arm.edit_bones.new('palm.04.L')
    bone.head[:] = 0.6929, 0.0696, 1.2871
    bone.tail[:] = 0.7528, 0.0763, 1.2428
    bone.roll = -2.5155
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.L']]
    bones['palm.04.L'] = bone.name
    bone = arm.edit_bones.new('palm.01.R')
    bone.head[:] = -0.6921, 0.0224, 1.2882
    bone.tail[:] = -0.7464, 0.0051, 1.2482
    bone.roll = 2.4928
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.R']]
    bones['palm.01.R'] = bone.name
    bone = arm.edit_bones.new('palm.02.R')
    bone.head[:] = -0.6970, 0.0389, 1.2877
    bone.tail[:] = -0.7518, 0.0277, 1.2487
    bone.roll = 2.5274
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.R']]
    bones['palm.02.R'] = bone.name
    bone = arm.edit_bones.new('palm.03.R')
    bone.head[:] = -0.6963, 0.0544, 1.2874
    bone.tail[:] = -0.7540, 0.0521, 1.2482
    bone.roll = 2.5843
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.R']]
    bones['palm.03.R'] = bone.name
    bone = arm.edit_bones.new('palm.04.R')
    bone.head[:] = -0.6929, 0.0696, 1.2871
    bone.tail[:] = -0.7528, 0.0763, 1.2428
    bone.roll = 2.5155
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['hand.R']]
    bones['palm.04.R'] = bone.name
    bone = arm.edit_bones.new('finger_index.01.L')
    bone.head[:] = 0.7464, 0.0051, 1.2482
    bone.tail[:] = 0.7718, 0.0013, 1.2112
    bone.roll = -2.0315
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.01.L']]
    bones['finger_index.01.L'] = bone.name
    bone = arm.edit_bones.new('thumb.01.L')
    bone.head[:] = 0.6705, 0.0214, 1.2738
    bone.tail[:] = 0.6857, 0.0015, 1.2404
    bone.roll = -0.1587
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['palm.01.L']]
    bones['thumb.01.L'] = bone.name
    bone = arm.edit_bones.new('finger_middle.01.L')
    bone.head[:] = 0.7518, 0.0277, 1.2487
    bone.tail[:] = 0.7762, 0.0234, 1.2058
    bone.roll = -2.0067
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.02.L']]
    bones['finger_middle.01.L'] = bone.name
    bone = arm.edit_bones.new('finger_ring.01.L')
    bone.head[:] = 0.7540, 0.0521, 1.2482
    bone.tail[:] = 0.7715, 0.0499, 1.2070
    bone.roll = -2.0082
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.03.L']]
    bones['finger_ring.01.L'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.01.L')
    bone.head[:] = 0.7528, 0.0763, 1.2428
    bone.tail[:] = 0.7589, 0.0765, 1.2156
    bone.roll = -1.9749
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.04.L']]
    bones['finger_pinky.01.L'] = bone.name
    bone = arm.edit_bones.new('finger_index.01.R')
    bone.head[:] = -0.7464, 0.0051, 1.2482
    bone.tail[:] = -0.7718, 0.0012, 1.2112
    bone.roll = 2.0315
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.01.R']]
    bones['finger_index.01.R'] = bone.name
    bone = arm.edit_bones.new('thumb.01.R')
    bone.head[:] = -0.6705, 0.0214, 1.2738
    bone.tail[:] = -0.6857, 0.0015, 1.2404
    bone.roll = 0.1587
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['palm.01.R']]
    bones['thumb.01.R'] = bone.name
    bone = arm.edit_bones.new('finger_middle.01.R')
    bone.head[:] = -0.7518, 0.0277, 1.2487
    bone.tail[:] = -0.7762, 0.0233, 1.2058
    bone.roll = 2.0067
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.02.R']]
    bones['finger_middle.01.R'] = bone.name
    bone = arm.edit_bones.new('finger_ring.01.R')
    bone.head[:] = -0.7540, 0.0521, 1.2482
    bone.tail[:] = -0.7715, 0.0499, 1.2070
    bone.roll = 2.0082
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.03.R']]
    bones['finger_ring.01.R'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.01.R')
    bone.head[:] = -0.7528, 0.0763, 1.2428
    bone.tail[:] = -0.7589, 0.0765, 1.2156
    bone.roll = 1.9749
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['palm.04.R']]
    bones['finger_pinky.01.R'] = bone.name
    bone = arm.edit_bones.new('finger_index.02.L')
    bone.head[:] = 0.7718, 0.0013, 1.2112
    bone.tail[:] = 0.7840, -0.0003, 1.1858
    bone.roll = -1.8799
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_index.01.L']]
    bones['finger_index.02.L'] = bone.name
    bone = arm.edit_bones.new('thumb.02.L')
    bone.head[:] = 0.6857, 0.0015, 1.2404
    bone.tail[:] = 0.7056, -0.0057, 1.2145
    bone.roll = -0.4798
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thumb.01.L']]
    bones['thumb.02.L'] = bone.name
    bone = arm.edit_bones.new('finger_middle.02.L')
    bone.head[:] = 0.7762, 0.0234, 1.2058
    bone.tail[:] = 0.7851, 0.0218, 1.1749
    bone.roll = -1.8283
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_middle.01.L']]
    bones['finger_middle.02.L'] = bone.name
    bone = arm.edit_bones.new('finger_ring.02.L')
    bone.head[:] = 0.7715, 0.0499, 1.2070
    bone.tail[:] = 0.7794, 0.0494, 1.1762
    bone.roll = -1.8946
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_ring.01.L']]
    bones['finger_ring.02.L'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.02.L')
    bone.head[:] = 0.7589, 0.0765, 1.2156
    bone.tail[:] = 0.7618, 0.0770, 1.1932
    bone.roll = -1.9059
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_pinky.01.L']]
    bones['finger_pinky.02.L'] = bone.name
    bone = arm.edit_bones.new('finger_index.02.R')
    bone.head[:] = -0.7718, 0.0012, 1.2112
    bone.tail[:] = -0.7840, -0.0003, 1.1858
    bone.roll = 1.8799
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_index.01.R']]
    bones['finger_index.02.R'] = bone.name
    bone = arm.edit_bones.new('thumb.02.R')
    bone.head[:] = -0.6857, 0.0015, 1.2404
    bone.tail[:] = -0.7056, -0.0057, 1.2145
    bone.roll = 0.4798
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thumb.01.R']]
    bones['thumb.02.R'] = bone.name
    bone = arm.edit_bones.new('finger_middle.02.R')
    bone.head[:] = -0.7762, 0.0233, 1.2058
    bone.tail[:] = -0.7851, 0.0218, 1.1749
    bone.roll = 1.8283
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_middle.01.R']]
    bones['finger_middle.02.R'] = bone.name
    bone = arm.edit_bones.new('finger_ring.02.R')
    bone.head[:] = -0.7715, 0.0499, 1.2070
    bone.tail[:] = -0.7794, 0.0494, 1.1762
    bone.roll = 1.8946
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_ring.01.R']]
    bones['finger_ring.02.R'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.02.R')
    bone.head[:] = -0.7589, 0.0765, 1.2156
    bone.tail[:] = -0.7618, 0.0770, 1.1932
    bone.roll = 1.9059
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_pinky.01.R']]
    bones['finger_pinky.02.R'] = bone.name
    bone = arm.edit_bones.new('finger_index.03.L')
    bone.head[:] = 0.7840, -0.0003, 1.1858
    bone.tail[:] = 0.7892, 0.0006, 1.1636
    bone.roll = -1.6760
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_index.02.L']]
    bones['finger_index.03.L'] = bone.name
    bone = arm.edit_bones.new('thumb.03.L')
    bone.head[:] = 0.7056, -0.0057, 1.2145
    bone.tail[:] = 0.7194, -0.0098, 1.1995
    bone.roll = -0.5826
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thumb.02.L']]
    bones['thumb.03.L'] = bone.name
    bone = arm.edit_bones.new('finger_middle.03.L')
    bone.head[:] = 0.7851, 0.0218, 1.1749
    bone.tail[:] = 0.7888, 0.0216, 1.1525
    bone.roll = -1.7483
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_middle.02.L']]
    bones['finger_middle.03.L'] = bone.name
    bone = arm.edit_bones.new('finger_ring.03.L')
    bone.head[:] = 0.7794, 0.0494, 1.1762
    bone.tail[:] = 0.7781, 0.0498, 1.1577
    bone.roll = -1.6582
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_ring.02.L']]
    bones['finger_ring.03.L'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.03.L')
    bone.head[:] = 0.7618, 0.0770, 1.1932
    bone.tail[:] = 0.7611, 0.0772, 1.1782
    bone.roll = -1.7639
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_pinky.02.L']]
    bones['finger_pinky.03.L'] = bone.name
    bone = arm.edit_bones.new('finger_index.03.R')
    bone.head[:] = -0.7840, -0.0003, 1.1858
    bone.tail[:] = -0.7892, 0.0006, 1.1636
    bone.roll = 1.6760
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_index.02.R']]
    bones['finger_index.03.R'] = bone.name
    bone = arm.edit_bones.new('thumb.03.R')
    bone.head[:] = -0.7056, -0.0057, 1.2145
    bone.tail[:] = -0.7194, -0.0098, 1.1995
    bone.roll = 0.5826
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thumb.02.R']]
    bones['thumb.03.R'] = bone.name
    bone = arm.edit_bones.new('finger_middle.03.R')
    bone.head[:] = -0.7851, 0.0218, 1.1749
    bone.tail[:] = -0.7888, 0.0216, 1.1525
    bone.roll = 1.7483
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_middle.02.R']]
    bones['finger_middle.03.R'] = bone.name
    bone = arm.edit_bones.new('finger_ring.03.R')
    bone.head[:] = -0.7794, 0.0494, 1.1762
    bone.tail[:] = -0.7781, 0.0498, 1.1577
    bone.roll = 1.6582
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_ring.02.R']]
    bones['finger_ring.03.R'] = bone.name
    bone = arm.edit_bones.new('finger_pinky.03.R')
    bone.head[:] = -0.7618, 0.0770, 1.1932
    bone.tail[:] = -0.7611, 0.0772, 1.1782
    bone.roll = 1.7639
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['finger_pinky.02.R']]
    bones['finger_pinky.03.R'] = bone.name

    bpy.ops.object.mode_set(mode='OBJECT')
    pbone = obj.pose.bones[bones['hips']]
    pbone.rigify_type = 'spine'
    pbone.rigify_parameters.add()
    pbone.rigify_parameters[0].chain_bone_controls = "1, 2, 3"
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['spine']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['thigh.L']]
    pbone.rigify_type = 'biped.leg'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_ik_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].ik_layers = [False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['thigh.R']]
    pbone.rigify_type = 'biped.leg'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_ik_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].ik_layers = [False, False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['ribs']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['shin.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['shin.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['neck']]
    pbone.rigify_type = 'neck_short'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['shoulder.L']]
    pbone.rigify_type = 'basic.copy'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    pbone = obj.pose.bones[bones['shoulder.R']]
    pbone.rigify_type = 'basic.copy'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    pbone = obj.pose.bones[bones['foot.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['heel.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['heel.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['foot.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['heel.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['heel.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['head']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['upper_arm.L']]
    pbone.rigify_type = 'biped.arm'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_ik_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].ik_layers = [False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['upper_arm.R']]
    pbone.rigify_type = 'biped.arm'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_ik_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].ik_layers = [False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['toe.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['toe.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['forearm.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['forearm.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['hand.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['hand.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.01.L']]
    pbone.rigify_type = 'palm'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    pbone = obj.pose.bones[bones['palm.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.04.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.01.R']]
    pbone.rigify_type = 'palm'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    pbone = obj.pose.bones[bones['palm.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['palm.04.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, True, True)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'YXZ'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_index.01.L']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['thumb.01.L']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_middle.01.L']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_ring.01.L']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_pinky.01.L']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_index.01.R']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['thumb.01.R']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_middle.01.R']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_ring.01.R']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_pinky.01.R']]
    pbone.rigify_type = 'finger'
    pbone.lock_location = (True, True, True)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone.rigify_parameters.add()
    try:
        pbone.rigify_parameters[0].separate_extra_layers = True
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters[0].extra_layers = [False, False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['finger_index.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['thumb.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_middle.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_ring.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_pinky.02.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_index.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['thumb.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_middle.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_ring.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_pinky.02.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_index.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['thumb.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_middle.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_ring.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_pinky.03.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_index.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['thumb.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_middle.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_ring.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]
    pbone = obj.pose.bones[bones['finger_pinky.03.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    pbone.bone.layers = [False, False, False, False, True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False]

    bpy.ops.object.mode_set(mode='EDIT')
    for bone in arm.edit_bones:
        bone.select = False
        bone.select_head = False
        bone.select_tail = False
    for b in bones:
        bone = arm.edit_bones[bones[b]]
        bone.select = True
        bone.select_head = True
        bone.select_tail = True
        arm.edit_bones.active = bone

    arm.layers = [(x in [0, 2, 4, 6, 8, 10, 12]) for x in range(0, 32)]
