/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.EnvironmentProfile;
import org.apache.fop.apps.EnvironmentalProfileFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.hyphenation.Hyphenator;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.xml.sax.SAXException;

public class FopConfParser {
    private static final String PREFER_RENDERER = "prefer-renderer";
    private static final String TABLE_BORDER_OVERPAINT = "table-border-overpaint";
    private static final String SIMPLE_LINE_BREAKING = "simple-line-breaking";
    private static final String SKIP_PAGE_POSITION_ONLY_ALLOWED = "skip-page-position-only-allowed";
    private static final String LEGACY_SKIP_PAGE_POSITION_ONLY = "legacy-skip-page-position-only";
    private static final String LEGACY_LAST_PAGE_CHANGE_IPD = "legacy-last-page-change-ipd";
    private static final String LEGACY_FO_WRAPPER = "legacy-fo-wrapper";
    private static final Log LOG = LogFactory.getLog(FopConfParser.class);
    private static final String ACCESSIBILITY = "accessibility";
    private final FopFactoryBuilder fopFactoryBuilder;

    public FopConfParser(InputStream fopConfStream, EnvironmentProfile enviro) throws SAXException, IOException {
        this(fopConfStream, enviro.getDefaultBaseURI(), enviro);
    }

    public FopConfParser(InputStream fopConfStream, URI defaultBaseURI, ResourceResolver resourceResolver) throws SAXException, IOException {
        this(fopConfStream, defaultBaseURI, EnvironmentalProfileFactory.createDefault(defaultBaseURI, resourceResolver));
    }

    public FopConfParser(InputStream fopConfStream, URI defaultBaseURI) throws SAXException, IOException {
        this(fopConfStream, defaultBaseURI, ResourceResolverFactory.createDefaultResourceResolver());
    }

    public FopConfParser(File fopConfFile) throws SAXException, IOException {
        this(fopConfFile, ResourceResolverFactory.createDefaultResourceResolver());
    }

    public FopConfParser(File fopConfFile, URI defaultBaseURI) throws SAXException, IOException {
        this((InputStream)new FileInputStream(fopConfFile), fopConfFile.toURI(), EnvironmentalProfileFactory.createDefault(defaultBaseURI, ResourceResolverFactory.createDefaultResourceResolver()));
    }

    public FopConfParser(File fopConfFile, ResourceResolver resourceResolver) throws SAXException, IOException {
        this((InputStream)new FileInputStream(fopConfFile), fopConfFile.getParentFile().toURI(), resourceResolver);
    }

    public FopConfParser(InputStream fopConfStream, URI baseURI, EnvironmentProfile enviro) throws SAXException, IOException {
        DefaultConfiguration cfg;
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        try {
            cfg = cfgBuilder.build(fopConfStream);
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
        this.fopFactoryBuilder = new FopFactoryBuilder(enviro).setConfiguration(cfg, false);
        this.configure(baseURI, enviro.getResourceResolver(), cfg);
    }

    public FopConfParser(Configuration cfg, FopFactoryBuilder fopFactoryBuilder) throws SAXException {
        this.fopFactoryBuilder = fopFactoryBuilder;
        this.configure(fopFactoryBuilder.getBaseURI(), ResourceResolverFactory.createDefaultResourceResolver(), cfg);
    }

    private void configure(URI baseURI, ResourceResolver resourceResolver, Configuration cfg) throws FOPException {
        Configuration pageConfig;
        boolean strict;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initializing FopFactory Configuration");
        }
        if (cfg.getChild("strict-validation", false) != null) {
            try {
                strict = cfg.getChild("strict-validation").getValueAsBoolean();
                this.fopFactoryBuilder.setStrictFOValidation(strict);
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        strict = false;
        if (cfg.getChild("strict-configuration", false) != null) {
            try {
                strict = cfg.getChild("strict-configuration").getValueAsBoolean();
                this.fopFactoryBuilder.setStrictUserConfigValidation(strict);
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(ACCESSIBILITY, false) != null) {
            try {
                this.fopFactoryBuilder.setAccessibility(cfg.getChild(ACCESSIBILITY).getValueAsBoolean());
                this.fopFactoryBuilder.setStaticRegionsPerPageForAccessibility(cfg.getChild(ACCESSIBILITY).getAttributeAsBoolean("static-region-per-page", false));
                this.fopFactoryBuilder.setKeepEmptyTags(cfg.getChild(ACCESSIBILITY).getAttributeAsBoolean("keep-empty-tags", true));
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild("base", false) != null) {
            try {
                URI confUri = InternalResourceResolver.getBaseURI(cfg.getChild("base").getValue(null));
                this.fopFactoryBuilder.setBaseURI(baseURI.resolve(confUri));
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(LOG, use, strict);
            }
        }
        if (cfg.getChild("source-resolution", false) != null) {
            float srcRes = cfg.getChild("source-resolution").getValueAsFloat(72.0f);
            this.fopFactoryBuilder.setSourceResolution(srcRes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("source-resolution set to: " + srcRes + "dpi"));
            }
        }
        if (cfg.getChild("target-resolution", false) != null) {
            float targetRes = cfg.getChild("target-resolution").getValueAsFloat(72.0f);
            this.fopFactoryBuilder.setTargetResolution(targetRes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("target-resolution set to: " + targetRes + "dpi"));
            }
        }
        if (cfg.getChild("break-indent-inheritance", false) != null) {
            try {
                this.fopFactoryBuilder.setBreakIndentInheritanceOnReferenceAreaBoundary(cfg.getChild("break-indent-inheritance").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, strict);
            }
        }
        if ((pageConfig = cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            String pageHeight = pageConfig.getAttribute("height", "11in");
            this.fopFactoryBuilder.setPageHeight(pageHeight);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Default page-height set to: " + pageHeight));
            }
        }
        if (pageConfig.getAttribute("width", null) != null) {
            String pageWidth = pageConfig.getAttribute("width", "8.26in");
            this.fopFactoryBuilder.setPageWidth(pageWidth);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Default page-width set to: " + pageWidth));
            }
        }
        if (cfg.getChild("complex-scripts") != null) {
            Configuration csConfig = cfg.getChild("complex-scripts");
            this.fopFactoryBuilder.setComplexScriptFeatures(!csConfig.getAttributeAsBoolean("disabled", false));
        }
        this.setHyphenationBase(cfg, resourceResolver, baseURI, this.fopFactoryBuilder);
        this.setHyphPatNames(cfg, this.fopFactoryBuilder, strict);
        if (cfg.getChild(PREFER_RENDERER, false) != null) {
            try {
                this.fopFactoryBuilder.setPreferRenderer(cfg.getChild(PREFER_RENDERER).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, strict);
            }
        }
        if (cfg.getChild(TABLE_BORDER_OVERPAINT, false) != null) {
            try {
                this.fopFactoryBuilder.setTableBorderOverpaint(cfg.getChild(TABLE_BORDER_OVERPAINT).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(SIMPLE_LINE_BREAKING, false) != null) {
            try {
                this.fopFactoryBuilder.setSimpleLineBreaking(cfg.getChild(SIMPLE_LINE_BREAKING).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(SKIP_PAGE_POSITION_ONLY_ALLOWED, false) != null) {
            try {
                this.fopFactoryBuilder.setSkipPagePositionOnlyAllowed(cfg.getChild(SKIP_PAGE_POSITION_ONLY_ALLOWED).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(LEGACY_SKIP_PAGE_POSITION_ONLY, false) != null) {
            try {
                this.fopFactoryBuilder.setLegacySkipPagePositionOnly(cfg.getChild(LEGACY_SKIP_PAGE_POSITION_ONLY).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(LEGACY_LAST_PAGE_CHANGE_IPD, false) != null) {
            try {
                this.fopFactoryBuilder.setLegacyLastPageChangeIPD(cfg.getChild(LEGACY_LAST_PAGE_CHANGE_IPD).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        if (cfg.getChild(LEGACY_FO_WRAPPER, false) != null) {
            try {
                this.fopFactoryBuilder.setLegacyFoWrapper(cfg.getChild(LEGACY_FO_WRAPPER).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, false);
            }
        }
        new FontManagerConfigurator(cfg, baseURI, this.fopFactoryBuilder.getBaseURI(), resourceResolver).configure(this.fopFactoryBuilder.getFontManager(), strict);
        this.configureImageLoading(cfg.getChild("image-loading", false), strict);
    }

    private void setHyphenationBase(Configuration cfg, ResourceResolver resourceResolver, URI baseURI, FopFactoryBuilder fopFactoryBuilder) throws FOPException {
        if (cfg.getChild("hyphenation-base", false) != null) {
            try {
                URI fontBase = InternalResourceResolver.getBaseURI(cfg.getChild("hyphenation-base").getValue(null));
                fopFactoryBuilder.setHyphenBaseResourceResolver(ResourceResolverFactory.createInternalResourceResolver(baseURI.resolve(fontBase), resourceResolver));
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(LOG, use, true);
            }
        } else {
            fopFactoryBuilder.setHyphenBaseResourceResolver(ResourceResolverFactory.createInternalResourceResolver(fopFactoryBuilder.getBaseURI(), resourceResolver));
        }
    }

    private void setHyphPatNames(Configuration cfg, FopFactoryBuilder builder, boolean strict) throws FOPException {
        Configuration[] hyphPatConfig = cfg.getChildren("hyphenation-pattern");
        if (hyphPatConfig.length != 0) {
            HashMap<String, String> hyphPatNames = new HashMap<String, String>();
            for (Configuration aHyphPatConfig : hyphPatConfig) {
                String filename;
                StringBuffer error = new StringBuffer();
                String location = aHyphPatConfig.getLocation();
                String lang = aHyphPatConfig.getAttribute("lang", null);
                if (lang == null) {
                    FopConfParser.addError("The lang attribute of a hyphenation-pattern configuration element must exist (" + location + ")", error);
                } else if (!lang.matches("[a-zA-Z]{2}")) {
                    FopConfParser.addError("The lang attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + location + ")", error);
                }
                lang = lang.toLowerCase(Locale.getDefault());
                String country = aHyphPatConfig.getAttribute("country", null);
                if ("".equals(country)) {
                    country = null;
                }
                if (country != null) {
                    if (!country.matches("[a-zA-Z]{2}")) {
                        FopConfParser.addError("The country attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + location + ")", error);
                    }
                    country = country.toUpperCase(Locale.getDefault());
                }
                if ((filename = aHyphPatConfig.getValue(null)) == null) {
                    FopConfParser.addError("The value of a hyphenation-pattern configuration element may not be empty (" + location + ")", error);
                }
                if (error.length() != 0) {
                    LogUtil.handleError(LOG, error.toString(), strict);
                    continue;
                }
                String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
                String extension = aHyphPatConfig.getAttribute("extension", null);
                if ("xml".equals(extension)) {
                    hyphPatNames.put(llccKey, filename + Hyphenator.XMLTYPE);
                } else if ("hyp".equals(extension)) {
                    hyphPatNames.put(llccKey, filename + Hyphenator.HYPTYPE);
                } else {
                    hyphPatNames.put(llccKey, filename);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Using hyphenation pattern filename " + filename + " for lang=\"" + lang + "\"" + (country != null ? ", country=\"" + country + "\"" : "")));
            }
            builder.setHyphPatNames(hyphPatNames);
        }
    }

    private static void addError(String message, StringBuffer error) {
        if (error.length() != 0) {
            error.append(". ");
        }
        error.append(message);
    }

    private void configureImageLoading(Configuration parent, boolean strict) throws FOPException {
        if (parent == null) {
            return;
        }
        ImageImplRegistry registry = this.fopFactoryBuilder.getImageManager().getRegistry();
        Configuration[] penalties = parent.getChildren("penalty");
        try {
            for (Configuration penaltyCfg : penalties) {
                String className = penaltyCfg.getAttribute("class");
                String value = penaltyCfg.getAttribute("value");
                Penalty p = null;
                if (value.toUpperCase(Locale.getDefault()).startsWith("INF")) {
                    p = Penalty.INFINITE_PENALTY;
                } else {
                    try {
                        p = Penalty.toPenalty((int)Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LogUtil.handleException(LOG, nfe, strict);
                    }
                }
                if (p == null) continue;
                registry.setAdditionalPenalty(className, p);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.handleException(LOG, e, strict);
        }
        registry.setICCConverter(parent.getAttribute("icc-converter", null));
    }

    public FopFactoryBuilder getFopFactoryBuilder() {
        return this.fopFactoryBuilder;
    }
}

