/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.flush;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FlushStats
implements Writeable,
ToXContentFragment {
    private long total;
    private long periodic;
    private long totalTimeInMillis;

    public FlushStats() {
    }

    public FlushStats(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.periodic = in.readVLong();
        }
    }

    public FlushStats(long total, long periodic, long totalTimeInMillis) {
        this.total = total;
        this.periodic = periodic;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long total, long periodic, long totalTimeInMillis) {
        this.total += total;
        this.periodic += periodic;
        this.totalTimeInMillis += totalTimeInMillis;
    }

    public void add(FlushStats flushStats) {
        this.addTotals(flushStats);
    }

    public void addTotals(FlushStats flushStats) {
        if (flushStats == null) {
            return;
        }
        this.total += flushStats.total;
        this.periodic += flushStats.periodic;
        this.totalTimeInMillis += flushStats.totalTimeInMillis;
    }

    public long getTotal() {
        return this.total;
    }

    public long getPeriodic() {
        return this.periodic;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("flush");
        builder.field("total", this.total);
        builder.field("periodic", this.periodic);
        builder.humanReadableField("total_time_in_millis", "total_time", this.getTotalTime());
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeVLong(this.periodic);
        }
    }

    static final class Fields {
        static final String FLUSH = "flush";
        static final String TOTAL = "total";
        static final String PERIODIC = "periodic";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";

        Fields() {
        }
    }
}

