/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePropertiesAction
implements ActionExecutor {
    public static final String PROPS_TO_ADD = "add";
    public static final String PROPS_TO_UPDATE = "update";
    public static final String PROPS_TO_DELETE = "delete";
    public static final String TARGET_ID_KEY = "targetId";
    public static final String TARGET_TYPE_KEY = "targetType";
    public static final String TARGET_TYPE_PROFILE = "profile";
    Logger logger = LoggerFactory.getLogger((String)UpdatePropertiesAction.class.getName());
    private ProfileService profileService;
    private EventService eventService;

    public int execute(Action action, Event event) {
        List propsToDelete;
        HashMap propsToUpdate;
        Profile target = event.getProfile();
        String targetId = (String)event.getProperty(TARGET_ID_KEY);
        String targetType = (String)event.getProperty(TARGET_TYPE_KEY);
        if (StringUtils.isNotBlank((CharSequence)targetId) && event.getProfile() != null && !targetId.equals(event.getProfile().getItemId())) {
            Object object = target = TARGET_TYPE_PROFILE.equals(targetType) ? this.profileService.load(targetId) : this.profileService.loadPersona(targetId);
            if (target == null) {
                this.logger.warn("No profile found with Id : {}. Update skipped.", (Object)targetId);
                return 0;
            }
        }
        boolean isProfileOrPersonaUpdated = false;
        HashMap propsToAdd = (HashMap)event.getProperties().get(PROPS_TO_ADD);
        if (propsToAdd != null) {
            isProfileOrPersonaUpdated |= this.processProperties(target, propsToAdd, "setIfMissing");
        }
        if ((propsToUpdate = (HashMap)event.getProperties().get(PROPS_TO_UPDATE)) != null) {
            isProfileOrPersonaUpdated |= this.processProperties(target, propsToUpdate, "alwaysSet");
        }
        if ((propsToDelete = (List)event.getProperties().get(PROPS_TO_DELETE)) != null) {
            for (String prop : propsToDelete) {
                isProfileOrPersonaUpdated |= PropertyHelper.setProperty((Object)target, (String)prop, null, (String)"remove");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)targetId) && isProfileOrPersonaUpdated && event.getProfile() != null && !targetId.equals(event.getProfile().getItemId())) {
            if (TARGET_TYPE_PROFILE.equals(targetType)) {
                this.profileService.save(target);
                Event profileUpdated = new Event("profileUpdated", null, target, null, null, (Item)target, new Date());
                profileUpdated.setPersistent(false);
                int changes = this.eventService.send(profileUpdated);
                if ((changes & 4) == 4) {
                    this.profileService.save(target);
                }
            } else {
                this.profileService.savePersona((Persona)target);
            }
            return 0;
        }
        return isProfileOrPersonaUpdated ? 4 : 0;
    }

    private boolean processProperties(Profile target, Map<String, Object> propsMap, String strategy) {
        boolean isProfileOrPersonaUpdated = false;
        for (String prop : propsMap.keySet()) {
            PropertyType propType = null;
            if (prop.startsWith("properties.") || prop.startsWith("systemProperties.")) {
                propType = this.profileService.getPropertyType(prop.substring(prop.indexOf(46) + 1));
            } else {
                propType = this.profileService.getPropertyType(prop);
                if (prop.equals("segments")) {
                    propsMap.put(prop, new HashSet((ArrayList)propsMap.get(prop)));
                }
            }
            if (propType != null) {
                isProfileOrPersonaUpdated |= PropertyHelper.setProperty((Object)target, (String)prop, (Object)PropertyHelper.getValueByTypeId((Object)propsMap.get(prop), (String)propType.getValueTypeId()), (String)"alwaysSet");
                continue;
            }
            isProfileOrPersonaUpdated |= PropertyHelper.setProperty((Object)target, (String)prop, (Object)propsMap.get(prop), (String)strategy);
        }
        return isProfileOrPersonaUpdated;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }
}

