/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import org.apache.uima.cas.impl.SlotKinds;

public class SerializationMeasures {
    public static final int MAX_NBR_ENCODE_LENGTH = 10;
    public int header = 0;
    public long origAuxByteArrayRefs = 0L;
    public long origAuxShortArrayRefs = 0L;
    public long origAuxLongArrayRefs = 0L;
    public long origAuxBytes = 0L;
    public long origAuxShorts = 0L;
    public long origAuxLongs = 0L;
    public long mainHeapFSs = 0L;
    public int stringsNbrCommon = 0;
    public long stringsCommonChars = 0L;
    public long stringsSavedExact = 0L;
    public long stringsSavedSubstr = 0L;
    public long totalTime = 0L;
    public final StatDetail[] statDetails = new StatDetail[SlotKinds.SlotKind.values().length];
    public final AllStatDetails allSlots;
    public final AllStatDetails strSlots;

    private static int maxIndexToZeros(int[] c) {
        for (int i = c.length - 1; i >= 0; --i) {
            if (c[i] == 0) continue;
            return Math.min(i + 1, c.length - 1);
        }
        return 1;
    }

    private static float percent(long a, long b) {
        if (a == 0L) {
            return 0.0f;
        }
        if (b == 0L) {
            return 100.0f;
        }
        return 100.0f * (float)a / (float)b;
    }

    public SerializationMeasures() {
        for (SlotKinds.SlotKind kind : SlotKinds.SlotKind.values()) {
            this.statDetails[kind.ordinal()] = new StatDetail(kind.toString(), kind.canBeNegative, kind.inMainHeap, kind.elementSize);
        }
        this.allSlots = new AllStatDetails("AllSlotKinds", SlotKinds.SlotKind.Slot_ArrayLength, SlotKinds.SlotKind.Slot_HeapRef, SlotKinds.SlotKind.Slot_Int, SlotKinds.SlotKind.Slot_Byte, SlotKinds.SlotKind.Slot_Short, SlotKinds.SlotKind.Slot_TypeCode, SlotKinds.SlotKind.Slot_StrOffset, SlotKinds.SlotKind.Slot_StrLength, SlotKinds.SlotKind.Slot_StrChars, SlotKinds.SlotKind.Slot_Long_High, SlotKinds.SlotKind.Slot_Long_Low, SlotKinds.SlotKind.Slot_Float_Mantissa_Sign, SlotKinds.SlotKind.Slot_Float_Exponent, SlotKinds.SlotKind.Slot_Double_Mantissa_Sign, SlotKinds.SlotKind.Slot_Double_Exponent, SlotKinds.SlotKind.Slot_FsIndexes);
        this.strSlots = new AllStatDetails("Strings", SlotKinds.SlotKind.Slot_StrOffset, SlotKinds.SlotKind.Slot_StrLength, SlotKinds.SlotKind.Slot_StrChars);
    }

    StatDetail[] toStatDetails(SlotKinds.SlotKind[] kinds) {
        StatDetail[] sds = new StatDetail[kinds.length];
        int i = 0;
        for (SlotKinds.SlotKind k : kinds) {
            sds[i++] = this.statDetails[k.ordinal()];
        }
        return sds;
    }

    public void accum(SerializationMeasures o) {
        int i = 0;
        for (StatDetail sd : o.statDetails) {
            this.statDetails[i++].accum(sd);
        }
        this.origAuxByteArrayRefs += o.origAuxByteArrayRefs;
        this.origAuxShortArrayRefs += o.origAuxShortArrayRefs;
        this.origAuxLongArrayRefs += o.origAuxLongArrayRefs;
        this.header += o.header;
        this.mainHeapFSs += o.mainHeapFSs;
        this.stringsNbrCommon += o.stringsNbrCommon;
        this.stringsCommonChars += o.stringsCommonChars;
        this.stringsSavedExact += o.stringsSavedExact;
        this.stringsSavedSubstr += o.stringsSavedSubstr;
    }

    public String toString() {
        long origStringChars = this.statDetails[SlotKinds.SlotKind.Slot_StrChars.ordinal()].getOriginal();
        long origStringObjs = this.statDetails[SlotKinds.SlotKind.Slot_StrLength.ordinal()].getOriginal() * 2L;
        long origStringsTot = origStringChars + origStringObjs + origStringObjs / 2L;
        this.allSlots.aggregate();
        this.strSlots.aggregate();
        long allOrig = this.statDetails[SlotKinds.SlotKind.Slot_MainHeap.ordinal()].original + origStringChars + origStringObjs + this.origAuxBytes + this.origAuxShorts + this.origAuxLongs;
        long allB4Z = this.allSlots.aggr.lengthTotal;
        long strB4Z = this.strSlots.aggr.lengthTotal;
        long allTotZ = this.allSlots.aggr.afterZip;
        long strTotZ = this.strSlots.aggr.afterZip;
        return String.format("Summary: withZip: %,d(%.1f%%), without: %,d(%.1f%%)  zipTime: %,d ms  totalSerTime: %,d ms%n  nonStrgs: withZip: %,d(%.1f%%), without: %,d(%.1f%%)%n  Strings:  withZip: %,d(%.1f%%), without: %,d(%.1f%%)%n  MainHeap TotFS: %,d, StrCmnChars: %,d(%.1f%%), StrSavedExact: %,d  StrSavedSubstr: %,d%n%s%n", allTotZ, Float.valueOf(SerializationMeasures.percent(allTotZ, allOrig)), allB4Z, Float.valueOf(SerializationMeasures.percent(allB4Z, allOrig)), this.allSlots.aggr.zipTime, this.totalTime, allTotZ - strTotZ, Float.valueOf(SerializationMeasures.percent(allTotZ - strTotZ, allOrig - origStringsTot)), allB4Z - strB4Z, Float.valueOf(SerializationMeasures.percent(allB4Z - strB4Z, allOrig - origStringsTot)), strTotZ, Float.valueOf(SerializationMeasures.percent(strTotZ, origStringsTot)), strB4Z, Float.valueOf(SerializationMeasures.percent(strB4Z, origStringsTot)), this.mainHeapFSs, this.stringsCommonChars, Float.valueOf(SerializationMeasures.percent(this.stringsCommonChars, this.statDetails[SlotKinds.SlotKind.Slot_StrChars.ordinal()].original)), this.stringsSavedExact, this.stringsSavedSubstr, this.allSlots.toString());
    }

    public static class StatDetail {
        private final String name;
        public long original = -1L;
        final boolean canBeNegative;
        public final int[] c = new int[10];
        private final int[] cn;
        private final int bytesPerCount;
        public int countTotal;
        public int lengthTotal;
        public long diffEncoded = 0L;
        public long valueLeDiff = 0L;
        public long beforeZip;
        public long afterZip = -1L;
        public long zipTime;
        public long deserializationTime;

        public StatDetail(String name, boolean canBeNegative, boolean inMainHeap, int bytesPerCount) {
            this.canBeNegative = canBeNegative;
            this.bytesPerCount = bytesPerCount;
            this.name = name;
            this.cn = (int[])(canBeNegative ? new int[10] : null);
            if (inMainHeap) {
                this.original = 0L;
            }
        }

        public long getOriginal() {
            if (this.original == -1L) {
                return this.countTotal * this.bytesPerCount;
            }
            return this.original;
        }

        public void accum(StatDetail o) {
            for (int i = 0; i < this.c.length; ++i) {
                int n = i;
                this.c[n] = this.c[n] + o.c[i];
                if (!this.canBeNegative || null == o.cn) continue;
                int n2 = i;
                this.cn[n2] = this.cn[n2] + o.cn[i];
            }
            this.countTotal += o.countTotal;
            this.lengthTotal += o.lengthTotal;
            this.original = this.getOriginal();
            this.original += o.getOriginal();
            this.diffEncoded += o.diffEncoded;
            this.valueLeDiff += o.valueLeDiff;
            this.beforeZip += o.beforeZip;
            if (this.afterZip == -1L) {
                this.afterZip = 0L;
            }
            this.afterZip += o.afterZip == -1L ? o.beforeZip : o.afterZip;
            this.zipTime += o.zipTime;
            this.deserializationTime += o.deserializationTime;
        }

        public void incr(int encodedLength, boolean isNegative) {
            if (isNegative) {
                int n = encodedLength - 1;
                this.cn[n] = this.cn[n] + 1;
            }
            this.incr(encodedLength);
        }

        public void incr(int encodedLength) {
            int n = encodedLength - 1;
            this.c[n] = this.c[n] + 1;
            ++this.countTotal;
            this.lengthTotal += encodedLength;
        }

        public void incrNoCompression(int v) {
            int n = this.bytesPerCount - 1;
            this.c[n] = this.c[n] + v;
            this.countTotal += v;
            this.lengthTotal += v * this.bytesPerCount;
        }

        public String toString() {
            long tot = this.lengthTotal;
            if (tot == 0L) {
                return String.format("Item: %25s%n", this.name);
            }
            String diff = 0L < this.diffEncoded ? String.format("%n                                                                  DiffEncoded(%%, %%v<diff): %,d(%.1f%% %.1f%%)", this.diffEncoded, Float.valueOf(SerializationMeasures.percent(this.diffEncoded, this.countTotal)), Float.valueOf(SerializationMeasures.percent(this.valueLeDiff, this.diffEncoded))) : "";
            String zp = this.afterZip == -1L ? "" : String.format(" afterZip: %,7d(%4.1f%%), %,3d ms", this.afterZip, Float.valueOf(SerializationMeasures.percent(this.afterZip, this.beforeZip)), this.zipTime);
            String dt = this.deserializationTime == 0L ? "" : String.format(" Deserialization time: %f", Float.valueOf((float)this.deserializationTime / 1000.0f));
            StringBuilder sb = new StringBuilder();
            int maxToInclude = SerializationMeasures.maxIndexToZeros(this.c);
            for (int i = 0; i <= maxToInclude; ++i) {
                sb.append(this.canBeNegative ? String.format(" %,d(%,d)", this.c[i], this.cn[i]) : String.format(" %,d", this.c[i]));
            }
            String totPct = this.original == 0L ? String.format("LengthTot: %,d", this.lengthTotal) : String.format("LengthTot: %,d(%.1f%%)", this.lengthTotal, Float.valueOf(this.percentCompr(this.lengthTotal)));
            String histoDetails = String.format("[%s  Histo:%s]", totPct, sb);
            return String.format("Item: %25s %s %s %s %s%n", this.name, zp, dt, histoDetails, diff);
        }

        private float percentCompr(long totCompr) {
            return SerializationMeasures.percent(totCompr, this.original == -1L || this.original == 0L ? (long)(this.countTotal * this.bytesPerCount) : this.original);
        }
    }

    public class AllStatDetails {
        final StatDetail[] allStatDetails;
        StatDetail aggr;
        final String name;

        public AllStatDetails(String aggrName, StatDetail ... someHeaps) {
            this.name = aggrName;
            this.allStatDetails = new StatDetail[someHeaps.length];
            this.aggr = new StatDetail(aggrName, true, true, 1);
            int i = 0;
            for (StatDetail sd : someHeaps) {
                this.allStatDetails[i++] = sd;
                this.aggr.accum(sd);
            }
        }

        public AllStatDetails(String aggrName, SlotKinds.SlotKind ... kinds) {
            this(aggrName, this$0.toStatDetails(kinds));
        }

        public void accum(AllStatDetails o) {
            for (int i = 0; i < this.allStatDetails.length; ++i) {
                this.allStatDetails[i].accum(o.allStatDetails[i]);
            }
        }

        public void aggregate() {
            this.aggr = new StatDetail(this.name, true, false, 1);
            for (StatDetail sd : this.allStatDetails) {
                this.aggr.accum(sd);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (StatDetail h : this.allStatDetails) {
                sb.append(h.toString());
            }
            return sb.toString();
        }
    }
}

