/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanAnnotationExpression
extends AbstractBooleanExpression {
    private final IAnnotationExpression e1;
    private final String op;
    private final IAnnotationExpression e2;

    public BooleanAnnotationExpression(IAnnotationExpression e1, String op, IAnnotationExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        AnnotationFS first = this.getFristExpression().getAnnotation(context, stream);
        AnnotationFS second = this.getSecondExpression().getAnnotation(context, stream);
        return this.eval(first, this.getOperator(), second);
    }

    private boolean eval(AnnotationFS t1, String op, AnnotationFS t2) {
        if ("==".equals(op)) {
            if (t1 == null) {
                return t2 == null;
            }
            return t1.equals((Object)t2);
        }
        if ("!=".equals(op)) {
            if (t1 == null) {
                return t2 != null;
            }
            return !t1.equals((Object)t2);
        }
        return false;
    }

    public IAnnotationExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public IAnnotationExpression getSecondExpression() {
        return this.e2;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

