/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class LongArray
extends Array<Long> {
    private long[] _data;

    public LongArray(long[] data) {
        super(data.length);
        this._data = data;
    }

    public long[] get() {
        return this._data;
    }

    @Override
    public Long get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, Long value) {
        this._data[index] = value != null ? value : 0L;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (long)value;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, (double)LongArray.parseLong(value));
    }

    @Override
    public void set(int rl, int ru, Array<Long> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = UtilFunctions.objectToLong(vt, value.get(i));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Long> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Long> value) {
        long[] data2 = ((LongArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == 0L) continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            long v = UtilFunctions.objectToLong(vt, value.get(i));
            if (v == 0L) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(LongArray.parseLong(value));
    }

    @Override
    public void append(Long value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value : 0L;
    }

    @Override
    public Array<Long> append(Array<Long> other) {
        int endSize = this._size + other.size();
        long[] ret = new long[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new LongArray(ret));
        }
        return new LongArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.INT64.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeLong(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readLong();
        }
    }

    @Override
    public Array<Long> clone() {
        return new LongArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Long> slice(int rl, int ru) {
        return new LongArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new long[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0L;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer longBuffer = ByteBuffer.allocate(8 * this._size);
        longBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this._size; ++i) {
            longBuffer.putLong(this._data[i]);
        }
        return longBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.INT64;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.INT64, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.INT64;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.longArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 8 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        BitSet ret = new BitSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != 0L && this._data[i] != 1L) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0L);
        }
        return new BitSetArray(ret, this.size());
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] < 0L || this._data[i] > 1L) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0L;
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i];
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            if (Math.abs(this._data[i]) > Integer.MAX_VALUE) {
                throw new DMLRuntimeException("Unable to change to integer from long array because of value:" + this._data[i]);
            }
            ret[i] = (int)this._data[i];
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        return this;
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        return new HashLongArray(this._data);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(LongArray.parseLong(value));
    }

    @Override
    public void fill(Long value) {
        value = value != null ? value : 0L;
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static long parseLong(String s) {
        if (s == null || s.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            if (s.contains(".")) {
                return (long)Double.parseDouble(s);
            }
            throw e;
        }
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString().charAt(0);
        }
        return new CharArray(ret);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Long> select(int[] indices) {
        long[] ret = new long[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new LongArray(ret);
    }

    @Override
    public Array<Long> select(boolean[] select, int nTrue) {
        long[] ret = new long[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new LongArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0L;
    }

    @Override
    public double hashDouble(int idx) {
        return Long.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Long> other) {
        if (other instanceof LongArray) {
            return Arrays.equals(this._data, ((LongArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

