/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Or;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceCol;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;

public class AggregateUnaryOperator
extends MultiThreadedOperator {
    private static final long serialVersionUID = 6690553323120787735L;
    public final AggregateOperator aggOp;
    public final IndexFunction indexFn;

    public AggregateUnaryOperator(AggregateOperator aop, IndexFunction iop) {
        this(aop, iop, 1);
    }

    public AggregateUnaryOperator(AggregateOperator aop, IndexFunction iop, int numThreads) {
        super(aop.increOp.fn instanceof Plus || aop.increOp.fn instanceof KahanPlus || aop.increOp.fn instanceof KahanPlusSq || aop.increOp.fn instanceof Or || aop.increOp.fn instanceof Minus);
        this.aggOp = aop;
        this.indexFn = iop;
        this._numThreads = numThreads;
    }

    public boolean isRowAggregate() {
        return this.indexFn instanceof ReduceCol;
    }

    public boolean isColAggregate() {
        return this.indexFn instanceof ReduceRow;
    }

    public boolean isFullAggregate() {
        return this.indexFn instanceof ReduceAll;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.aggOp);
        sb.append(", ");
        sb.append(this.indexFn);
        sb.append(")");
        return sb.toString();
    }
}

