/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.data.LibTensorReorg;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.util.DataConverter;

public class ReshapeCPInstruction
extends UnaryCPInstruction {
    private final CPOperand _opRows;
    private final CPOperand _opCols;
    private final CPOperand _opDims;
    private final CPOperand _opByRow;

    private ReshapeCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand in5, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Reshape, op, in1, out, opcode, istr);
        this._opRows = in2;
        this._opCols = in3;
        this._opDims = in4;
        this._opByRow = in5;
    }

    public static ReshapeCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[4]);
        CPOperand in5 = new CPOperand(parts[5]);
        CPOperand out = new CPOperand(parts[6]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an ReshapeInstruction: " + str);
        }
        return new ReshapeCPInstruction(new Operator(true), in1, in2, in3, in4, in5, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.output.getDataType() == Types.DataType.TENSOR) {
            int[] dims = DataConverter.getTensorDimensions(ec, this._opDims);
            TensorBlock out = new TensorBlock(this.output.getValueType(), dims);
            if (this.input1.getDataType() == Types.DataType.TENSOR) {
                TensorBlock data = ec.getTensorInput(this.input1.getName());
                LibTensorReorg.reshape(data.getBasicTensor(), out.getBasicTensor(), dims);
                ec.releaseTensorInput(this.input1.getName());
            } else if (this.input1.getDataType() == Types.DataType.MATRIX) {
                out.allocateBlock();
                MatrixBlock data = ec.getMatrixInput(this.input1.getName());
                out.getBasicTensor().set(data);
                ec.releaseMatrixInput(this.input1.getName());
            } else {
                throw new DMLRuntimeException("ReshapeInstruction only supports tensor and matrix as data parameter.");
            }
            ec.setTensorOutput(this.output.getName(), out);
        } else {
            MatrixBlock in = ec.getMatrixInput(this.input1.getName());
            int rows = (int)ec.getScalarInput(this._opRows).getLongValue();
            int cols = (int)ec.getScalarInput(this._opCols).getLongValue();
            BooleanObject byRow = (BooleanObject)ec.getScalarInput(this._opByRow.getName(), Types.ValueType.BOOLEAN, this._opByRow.isLiteral());
            MatrixBlock out = new MatrixBlock();
            LibMatrixReorg.reshape(in, out, rows, cols, byRow.getBooleanValue());
            ec.releaseMatrixInput(this.input1.getName());
            ec.setMatrixOutput(this.output.getName(), out);
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this._opRows, this._opCols, this._opDims, this._opByRow)));
    }

    public CPOperand getOpRows() {
        return this._opRows;
    }

    public CPOperand getOpCols() {
        return this._opCols;
    }

    public CPOperand getOpDims() {
        return this._opDims;
    }

    public CPOperand getOpByRow() {
        return this._opByRow;
    }
}

