/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.sort.IndexSortComparable;
import org.apache.sysml.runtime.util.MapReduceTool;

public class IndexSortReducer
extends MapReduceBase
implements Reducer<IndexSortComparable, LongWritable, MatrixIndexes, MatrixBlock> {
    private String _taskID = null;
    private int _brlen = -1;
    private MatrixIndexes _indexes = null;
    private MatrixBlock _data = null;
    private int _pos = 0;
    private OutputCollector<MatrixIndexes, MatrixBlock> _out = null;

    public void reduce(IndexSortComparable key, Iterator<LongWritable> values, OutputCollector<MatrixIndexes, MatrixBlock> out, Reporter report) throws IOException {
        this._out = out;
        int count = 0;
        while (values.hasNext()) {
            if (this._pos >= this._brlen) {
                this._indexes.setIndexes(this._indexes.getRowIndex() + 1L, this._indexes.getColumnIndex());
                out.collect((Object)this._indexes, (Object)this._data);
                this._pos = 0;
                this._data.reset(this._brlen, 1, false);
            }
            this._data.quickSetValue(this._pos, 0, values.next().get());
            ++this._pos;
            ++count;
        }
        report.incrCounter("num.values.in", this._taskID, count);
    }

    public void configure(JobConf job) {
        this._taskID = MapReduceTool.getUniqueKeyPerTask(job, false);
        this._brlen = MRJobConfiguration.getNumRowsPerBlock(job, (byte)0);
        this._pos = 0;
        this._data = new MatrixBlock(this._brlen, 1, false);
        this._indexes = new MatrixIndexes(0L, Long.parseLong(this._taskID));
    }

    public void close() throws IOException {
        if (this._pos > 0) {
            this._indexes.setIndexes(this._indexes.getRowIndex() + 1L, this._indexes.getColumnIndex());
            this._data.setNumRows(this._pos);
            this._out.collect((Object)this._indexes, (Object)this._data);
        }
    }
}

