/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.ArrayList;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;

public class LopProperties {
    private static IDSequence UniqueLopID = null;
    long ID = UniqueLopID.getNextID();
    int level;
    ExecType execType = ExecType.INVALID;
    ExecLocation execLoc = ExecLocation.INVALID;
    int compatibleJobs = JobType.INVALID.getBase();
    boolean breaksAlignment = true;
    boolean isAligner = false;
    boolean definesMRJob = false;
    boolean producesIntermediateOutput = false;

    public long getID() {
        return this.ID;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    public ExecLocation getExecLocation() {
        return this.execLoc;
    }

    public ExecType getExecType() {
        return this.execType;
    }

    public int getCompatibleJobs() {
        return this.compatibleJobs;
    }

    public boolean getBreaksAlignment() {
        return this.breaksAlignment;
    }

    public boolean getDefinesMRJob() {
        return this.definesMRJob;
    }

    public boolean isAligner() {
        return this.isAligner;
    }

    public boolean getProducesIntermediateOutput() {
        return this.producesIntermediateOutput;
    }

    public void setExecLocation(ExecLocation el) {
        this.execLoc = el;
    }

    public void addCompatibility(JobType jt) {
        this.compatibleJobs |= jt.getBase();
    }

    public void removeCompatibility(JobType jt) {
        this.compatibleJobs ^= jt.getBase();
    }

    public void removeNonPiggybackableJobs() {
        for (JobType jt : JobType.values()) {
            if (!jt.allowsNoOtherInstructions()) continue;
            this.compatibleJobs ^= jt.getBase();
        }
    }

    public void setCompatibleJobs(int cj) {
        this.compatibleJobs = cj;
    }

    public void setDefinesMRJob(boolean dmrj) {
        this.definesMRJob = dmrj;
    }

    public void setBreaksAlignment(boolean ba) {
        this.breaksAlignment = ba;
    }

    public void setAligner(boolean align) {
        this.isAligner = align;
    }

    public void setProducesIntermediateOutput(boolean pio) {
        this.producesIntermediateOutput = pio;
    }

    public void setLevel(ArrayList<Lop> inputs) {
        int tmplevel = -1;
        if (inputs == null || inputs.isEmpty()) {
            tmplevel = 0;
        } else {
            for (Lop in : inputs) {
                if (tmplevel >= in.getLevel()) continue;
                tmplevel = in.getLevel();
            }
            ++tmplevel;
        }
        this.setLevel(tmplevel);
    }

    public void setProperties(ArrayList<Lop> inputs, ExecType et, ExecLocation el, boolean ba, boolean aligner, boolean definesMR) {
        this.execType = et;
        this.execLoc = el;
        this.breaksAlignment = ba;
        this.isAligner = aligner;
        this.definesMRJob = definesMR;
        this.setLevel(inputs);
    }

    static {
        UniqueLopID = new IDSequence();
    }

    public static enum ExecLocation {
        INVALID,
        RecordReader,
        Map,
        MapOrReduce,
        MapAndReduce,
        Reduce,
        Data,
        ControlProgram;

    }

    public static enum ExecType {
        CP,
        CP_FILE,
        MR,
        SPARK,
        GPU,
        INVALID;

    }
}

