/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.test.Kind;
import org.apache.avro.test.TestRecordWithUnion;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificDatumWriter {
    @Test
    public void testResolveUnion() throws IOException {
        SpecificDatumWriter writer = new SpecificDatumWriter();
        Schema schema = TestRecordWithUnion.SCHEMA$;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        writer.setSchema(schema);
        TestRecordWithUnion c = TestRecordWithUnion.newBuilder().setKind(Kind.BAR).setValue("rab").build();
        writer.write((Object)c, (Encoder)encoder);
        encoder.flush();
        out.close();
        String expectedJson = String.format("{'kind':{'org.apache.avro.test.Kind':'%s'},'value':{'string':'%s'}}", c.getKind().toString(), c.getValue()).replace('\'', '\"');
        Assert.assertEquals((Object)expectedJson, (Object)out.toString("UTF-8"));
    }
}

