/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DenseBlockDRB
extends DenseBlock {
    private static final long serialVersionUID = 8546723684649816489L;
    private double[] data;
    private int rlen;
    private int clen;

    public DenseBlockDRB(int rlen, int clen) {
        this.reset(rlen, clen, 0.0);
    }

    public DenseBlockDRB(double[] data, int rlen, int clen) {
        this.data = data;
        this.rlen = rlen;
        this.clen = clen;
    }

    @Override
    public void reset() {
        this.reset(this.rlen, this.clen, 0.0);
    }

    @Override
    public void reset(int rlen, int clen) {
        this.reset(rlen, clen, 0.0);
    }

    @Override
    public void reset(int rlen, int clen, double v) {
        int len = rlen * clen;
        if ((long)len > this.capacity()) {
            this.data = new double[len];
            if (v != 0.0) {
                Arrays.fill(this.data, v);
            }
        } else {
            Arrays.fill(this.data, 0, len, v);
        }
        this.rlen = rlen;
        this.clen = clen;
    }

    @Override
    public int numRows() {
        return this.rlen;
    }

    @Override
    public int numBlocks() {
        return 1;
    }

    @Override
    public int blockSize() {
        return this.rlen;
    }

    @Override
    public int blockSize(int bix) {
        return this.rlen;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return true;
    }

    @Override
    public long size() {
        return this.rlen * this.clen;
    }

    @Override
    public int size(int bix) {
        return this.rlen * this.clen;
    }

    @Override
    public long capacity() {
        return this.data != null ? (long)this.data.length : -1L;
    }

    @Override
    public long countNonZeros() {
        return UtilFunctions.computeNnz(this.data, 0, this.rlen * this.clen);
    }

    @Override
    public int countNonZeros(int r) {
        return UtilFunctions.computeNnz(this.data, r * this.clen, this.clen);
    }

    @Override
    public long countNonZeros(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        if (cl == 0 && cu == this.clen) {
            nnz += (long)UtilFunctions.computeNnz(this.data, rl * this.clen, (ru - rl) * this.clen);
        } else {
            int i = rl;
            int ix = rl * this.clen;
            while (i < ru) {
                nnz += (long)UtilFunctions.computeNnz(this.data, ix + cl, cu - cl);
                ++i;
                ix += this.clen;
            }
        }
        return nnz;
    }

    @Override
    public double[][] values() {
        return new double[][]{this.data};
    }

    @Override
    public double[] values(int r) {
        return this.data;
    }

    @Override
    public double[] valuesAt(int bix) {
        return this.data;
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public int pos(int r) {
        return r * this.clen;
    }

    @Override
    public int pos(int r, int c) {
        return r * this.clen + c;
    }

    @Override
    public void incr(int r, int c) {
        int n = this.pos(r, c);
        this.data[n] = this.data[n] + 1.0;
    }

    @Override
    public void incr(int r, int c, double delta) {
        int n = this.pos(r, c);
        this.data[n] = this.data[n] + delta;
    }

    @Override
    public DenseBlock set(double v) {
        Arrays.fill(this.data, 0, this.rlen * this.clen, v);
        return this;
    }

    @Override
    public DenseBlock set(int rl, int ru, int cl, int cu, double v) {
        if (cl == 0 && cu == this.clen) {
            Arrays.fill(this.data, rl * this.clen, ru * this.clen, v);
        } else {
            int i = rl;
            int ix = rl * this.clen;
            while (i < ru) {
                Arrays.fill(this.data, ix + cl, ix + cu, v);
                ++i;
                ix += this.clen;
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this.data[this.pos((int)r, (int)c)] = v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        System.arraycopy(db.valuesAt(0), 0, this.data, 0, this.rlen * this.clen);
        return this;
    }

    @Override
    public DenseBlock set(int rl, int ru, int cl, int cu, DenseBlock db) {
        double[] a = db.valuesAt(0);
        if (cl == 0 && cu == this.clen) {
            System.arraycopy(a, 0, this.data, rl * this.clen + cl, (int)db.size());
        } else {
            int len = cu - cl;
            int i = rl;
            int ix1 = 0;
            int ix2 = rl * this.clen + cl;
            while (i < ru) {
                System.arraycopy(a, ix1, this.data, ix2, len);
                ++i;
                ix1 += len;
                ix2 += this.clen;
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        System.arraycopy(v, 0, this.data, this.pos(r), this.clen);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this.data[this.pos(r, c)];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int ix = 0;
        while (i < this.rlen) {
            for (int j = 0; j < this.clen; ++j) {
                sb.append(this.data[ix + j]);
                sb.append("\t");
            }
            sb.append("\n");
            ++i;
            ix += this.clen;
        }
        return sb.toString();
    }
}

