/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl.components;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.SerializerFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={SerializerFactory.class}, property={"service.vendor=The Apache Software Foundation", "pipeline.type=xml-serializer"})
public class XMLSerializerFactory
implements SerializerFactory {
    @Override
    public Serializer createSerializer() {
        return new XMLSerializer();
    }

    public class XMLSerializer
    extends org.apache.cocoon.components.serializers.util.XMLSerializer
    implements Serializer {
        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            String encoding = (String)config.getConfiguration().get("encoding", (Object)"UTF-8");
            try {
                this.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw new IOException("Encoding not supported: " + encoding);
            }
            this.setIndentPerLevel((Integer)config.getConfiguration().get("indent", (Object)0));
            this.setup((HttpServletRequest)context.getRequest());
            this.setOutputStream(context.getOutputStream());
        }

        @Override
        public void dispose() {
        }
    }
}

