/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic;

import com.googlecode.pngtastic.core.PngColorCounter;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PngtasticColorCounter {
    private static final String HELP = "java -jar pngtastic-x.x.jar com.googlecode.pngtastic.PngtasticColorCounter [options] file1 [file2 ..]\nOptions:\n  --distThreshold    the distance below which two colors are considered similar (0.0 to 1.0)\n  --freqThreshold    the percentage a color must be represented in the overall image (0.0 to 1.0)\n  --minAlpha         the minimum alpha channel value a pixel must have\n  --timeout          the number of milliseconds after which color counting will be aborted\n  --logLevel         the level of logging output (none, debug, info, or error)\n";

    public PngtasticColorCounter(String[] fileNames, String logLevel, double distThreshold, double freqThreshold, int minAlpha, long timeout) {
        long start = System.currentTimeMillis();
        PngColorCounter counter = new PngColorCounter(logLevel, distThreshold, freqThreshold, minAlpha, timeout);
        for (String file : fileNames) {
            try {
                PngImage image = new PngImage(file, logLevel);
                counter.count(image);
                System.out.println(counter.getResult());
            }
            catch (PngException | IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(String.format("Processed in %d milliseconds", System.currentTimeMillis() - start));
    }

    public static void main(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        int last = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--")) continue;
            int next = i + 1;
            if (next < args.length) {
                options.put(arg, args[next]);
                last = next + 1;
                continue;
            }
            options.put(arg, null);
            last = next;
        }
        String[] files = Arrays.copyOfRange(args, last, args.length);
        if (files.length == 0) {
            System.out.println("No files to process");
            System.out.println(HELP);
            return;
        }
        Double distThreshold = PngtasticColorCounter.safeDouble((String)options.get("--distThreshold"), 0.005);
        Double freqThreshold = PngtasticColorCounter.safeDouble((String)options.get("--freqThreshold"), 5.0E-4);
        Integer minAlpha = PngtasticColorCounter.safeInteger((String)options.get("--minAlpha"), 30);
        Integer timeout = PngtasticColorCounter.safeInteger((String)options.get("--timeout"), 0);
        String logLevel = (String)options.get("--logLevel");
        new PngtasticColorCounter(files, logLevel, distThreshold, freqThreshold, minAlpha, timeout.intValue());
    }

    private static Integer safeInteger(String input, Integer dflt) {
        try {
            return Integer.valueOf(input);
        }
        catch (Exception e) {
            return dflt;
        }
    }

    private static Double safeDouble(String input, Double dflt) {
        try {
            return Double.valueOf(input);
        }
        catch (Exception e) {
            return dflt;
        }
    }
}

