/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;

public class ClusterSyncHistory {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    protected List<HistoryEntry> history = new LinkedList<HistoryEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSyncHistory() {
        List<HistoryEntry> snapshot;
        List<HistoryEntry> list = this.history;
        synchronized (list) {
            snapshot = Collections.unmodifiableList(this.history);
        }
        ArrayList<String> result = new ArrayList<String>(snapshot.size());
        for (HistoryEntry historyEntry : snapshot) {
            result.add(historyEntry.fullLine);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHistoryEntry(BaseTopologyView view, String msg) {
        List<HistoryEntry> list = this.history;
        synchronized (list) {
            for (int i = this.history.size() - 1; i >= 0; --i) {
                HistoryEntry entry = this.history.get(i);
                if (!entry.view.equals(view)) break;
                if (!entry.msg.equals(msg)) continue;
                return;
            }
            String fullLine = this.sdf.format(Calendar.getInstance().getTime()) + ": " + msg;
            HistoryEntry newEntry = new HistoryEntry();
            newEntry.view = view;
            newEntry.fullLine = fullLine;
            newEntry.msg = msg;
            this.history.add(newEntry);
            while (this.history.size() > 12) {
                this.history.remove(0);
            }
        }
    }

    class HistoryEntry {
        BaseTopologyView view;
        String msg;
        String fullLine;

        HistoryEntry() {
        }
    }
}

