/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Scheduler.class}, scope=ServiceScope.BUNDLE, property={"service.vendor=The Apache Software Foundation"})
public class SchedulerServiceFactory
implements Scheduler {
    private long bundleId;
    @Reference
    private QuartzScheduler scheduler;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleId = ctx.getUsingBundle().getBundleId();
    }

    @Override
    public boolean schedule(Object job, ScheduleOptions options) {
        return this.scheduler.schedule(this.bundleId, null, job, options);
    }

    @Override
    public boolean unschedule(String jobName) {
        return this.scheduler.unschedule(this.bundleId, jobName);
    }

    @Override
    public ScheduleOptions NOW() {
        return this.scheduler.NOW();
    }

    @Override
    public ScheduleOptions NOW(int times, long period) {
        return this.scheduler.NOW(times, period);
    }

    @Override
    public ScheduleOptions AT(Date date) {
        return this.scheduler.AT(date);
    }

    @Override
    public ScheduleOptions AT(Date date, int times, long period) {
        return this.scheduler.AT(date, times, period);
    }

    @Override
    public ScheduleOptions EXPR(String expression) {
        return this.scheduler.EXPR(expression);
    }

    @Override
    public void addJob(String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws Exception {
        this.scheduler.addJob(this.bundleId, null, name, job, config, schedulingExpression, canRunConcurrently);
    }

    @Override
    public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws Exception {
        this.scheduler.addPeriodicJob(this.bundleId, null, name, job, config, period, canRunConcurrently);
    }

    @Override
    public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently, boolean startImmediate) throws Exception {
        this.scheduler.addPeriodicJob(this.bundleId, null, name, job, config, period, canRunConcurrently, startImmediate);
    }

    @Override
    public void fireJob(Object job, Map<String, Serializable> config) throws Exception {
        this.scheduler.fireJob(this.bundleId, null, job, config);
    }

    @Override
    public boolean fireJob(Object job, Map<String, Serializable> config, int times, long period) {
        return this.scheduler.fireJob(this.bundleId, null, job, config, times, period);
    }

    @Override
    public void fireJobAt(String name, Object job, Map<String, Serializable> config, Date date) throws Exception {
        this.scheduler.fireJobAt(this.bundleId, null, name, job, config, date);
    }

    @Override
    public boolean fireJobAt(String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
        return this.scheduler.fireJobAt(this.bundleId, null, name, job, config, date, times, period);
    }

    @Override
    public void removeJob(String name) throws NoSuchElementException {
        this.scheduler.removeJob(this.bundleId, name);
    }
}

