/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/evaluation_helper.h>
#include <plc4c/driver_s7_static.h>

#include "cyc_service_item_type.h"

// Code generated by code-generation. DO NOT EDIT.

// Array of discriminator values that match the enum type constants.
// (The order is identical to the enum constants, so we can use the
// enum constant to directly access a given type's discriminator values)
const plc4c_s7_read_write_cyc_service_item_type_discriminator plc4c_s7_read_write_cyc_service_item_type_discriminators[] = {
  {/* plc4c_s7_read_write_cyc_service_item_any_type */
   .syntaxId = 0x10 },
  {/* plc4c_s7_read_write_cyc_service_item_db_read_type */
   .syntaxId = 0xb0 }

};

// Function returning the discriminator values for a given type constant.
plc4c_s7_read_write_cyc_service_item_type_discriminator plc4c_s7_read_write_cyc_service_item_type_get_discriminator(plc4c_s7_read_write_cyc_service_item_type_type type) {
  return plc4c_s7_read_write_cyc_service_item_type_discriminators[type];
}

// Create an empty NULL-struct
static const plc4c_s7_read_write_cyc_service_item_type plc4c_s7_read_write_cyc_service_item_type_null_const;

plc4c_s7_read_write_cyc_service_item_type plc4c_s7_read_write_cyc_service_item_type_null() {
  return plc4c_s7_read_write_cyc_service_item_type_null_const;
}


// Constant values.
static const uint8_t PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID_const = 0x12;
uint8_t PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID() {
  return PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_cyc_service_item_type_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_cyc_service_item_type** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_cyc_service_item_type));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Const Field (functionId)
  uint8_t functionId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &functionId);
  if(_res != OK) {
    return _res;
  }
  if(functionId != PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID()) {
    return PARSE_ERROR;
    // throw new ParseException("Expected constant value " + PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID + " but got " + functionId);
  }

  // Simple Field (byteLength)
  uint8_t byteLength = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &byteLength);
  if(_res != OK) {
    return _res;
  }
  (*_message)->byte_length = byteLength;

  // Simple Field (syntaxId)
  uint8_t syntaxId = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &syntaxId);
  if(_res != OK) {
    return _res;
  }
  (*_message)->syntax_id = syntaxId;

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
if( syntaxId == 0x10 ) { /* CycServiceItemAnyType */
    (*_message)->_type = plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_any_type;

  // Enum field (transportSize)
  plc4c_s7_read_write_transport_size transportSize = plc4c_s7_read_write_transport_size_null();
  {
    uint8_t _constantValue = 0;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &_constantValue);
    if(_res != OK) {
      return _res;
    }
    transportSize = plc4c_s7_read_write_transport_size_get_first_enum_for_field_code(_constantValue);
  }
  (*_message)->cyc_service_item_any_type_transport_size = transportSize;


  // Simple Field (length)
  uint16_t length = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &length);
  if(_res != OK) {
    return _res;
  }
  (*_message)->cyc_service_item_any_type_length = length;


  // Simple Field (dbNumber)
  uint16_t dbNumber = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &dbNumber);
  if(_res != OK) {
    return _res;
  }
  (*_message)->cyc_service_item_any_type_db_number = dbNumber;


  // Simple Field (memoryArea)
  plc4c_s7_read_write_memory_area memoryArea;
  _res = plc4c_s7_read_write_memory_area_parse(ctx, readBuffer, (void*) &memoryArea);
  if(_res != OK) {
    return _res;
  }
  (*_message)->cyc_service_item_any_type_memory_area = memoryArea;


  // Simple Field (address)
  uint32_t address = 0;
  _res = plc4c_spi_read_unsigned_int(readBuffer, 24, (uint32_t*) &address);
  if(_res != OK) {
    return _res;
  }
  (*_message)->cyc_service_item_any_type_address = address;
  } else 
if( syntaxId == 0xb0 ) { /* CycServiceItemDbReadType */
    (*_message)->_type = plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_db_read_type;

  // Simple Field (numberOfAreas)
  uint8_t numberOfAreas = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &numberOfAreas);
  if(_res != OK) {
    return _res;
  }
  (*_message)->cyc_service_item_db_read_type_number_of_areas = numberOfAreas;


  // Array field (items)
  plc4c_list* items = NULL;
  plc4c_utils_list_create(&items);
  if(items == NULL) {
    return NO_MEMORY;
  }
  {
    // Count array
    uint16_t itemCount = (uint16_t) numberOfAreas;
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_sub_item* _value = NULL;
      _res = plc4c_s7_read_write_sub_item_parse(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), readBuffer, (void*) &_value);
      if(_res != OK) {
        return _res;
      }
      plc4c_utils_list_insert_head_value(items, _value);
    }
  }
  (*_message)->cyc_service_item_db_read_type_items = items;
  }

  return OK;
}

plc4c_return_code plc4c_s7_read_write_cyc_service_item_type_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_cyc_service_item_type* _message) {
  plc4c_return_code _res = OK;

  // Const Field (functionId)
  plc4c_spi_write_unsigned_byte(writeBuffer, 8, PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID());

  // Simple Field (byteLength)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->byte_length);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (syntaxId)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->syntax_id);
  if(_res != OK) {
    return _res;
  }

  // Switch Field (Depending on the current type, serialize the subtype elements)
  switch(_message->_type) {
    case plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_any_type: {

  // Enum field (transportSize)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, plc4c_s7_read_write_transport_size_get_code(_message->cyc_service_item_any_type_transport_size));
  if(_res != OK) {
    return _res;
  }

  // Simple Field (length)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->cyc_service_item_any_type_length);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (dbNumber)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->cyc_service_item_any_type_db_number);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (memoryArea)
  _res = plc4c_s7_read_write_memory_area_serialize(ctx, writeBuffer, &_message->cyc_service_item_any_type_memory_area);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (address)
  _res = plc4c_spi_write_unsigned_int(writeBuffer, 24, _message->cyc_service_item_any_type_address);
  if(_res != OK) {
    return _res;
  }

      break;
    }
    case plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_db_read_type: {

  // Simple Field (numberOfAreas)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->cyc_service_item_db_read_type_number_of_areas);
  if(_res != OK) {
    return _res;
  }

  // Array field (items)
  {
    uint8_t itemCount = plc4c_utils_list_size(_message->cyc_service_item_db_read_type_items);
    for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_s7_read_write_sub_item* _value = (plc4c_s7_read_write_sub_item*) plc4c_utils_list_get_value(_message->cyc_service_item_db_read_type_items, curItem);
      _res = plc4c_s7_read_write_sub_item_serialize(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), writeBuffer, (void*) _value);
      if(_res != OK) {
        return _res;
      }
    }
  }

      break;
    }
  }

  return OK;
}

uint16_t plc4c_s7_read_write_cyc_service_item_type_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_cyc_service_item_type* _message) {
  return plc4c_s7_read_write_cyc_service_item_type_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_cyc_service_item_type_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_cyc_service_item_type* _message) {
  uint16_t lengthInBits = 0;

  // Const Field (functionId)
  lengthInBits += 8;

  // Simple field (byteLength)
  lengthInBits += 8;

  // Simple field (syntaxId)
  lengthInBits += 8;

  // Depending on the current type, add the length of sub-type elements ...
  switch(_message->_type) {
    case plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_any_type: {

  // Enum Field (transportSize)
  lengthInBits += 8;


  // Simple field (length)
  lengthInBits += 16;


  // Simple field (dbNumber)
  lengthInBits += 16;


  // Simple field (memoryArea)
  lengthInBits += plc4c_s7_read_write_memory_area_length_in_bits(ctx, &_message->cyc_service_item_any_type_memory_area);


  // Simple field (address)
  lengthInBits += 24;

      break;
    }
    case plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_db_read_type: {

  // Simple field (numberOfAreas)
  lengthInBits += 8;


  // Array field
  if(_message->cyc_service_item_db_read_type_items != NULL) {
   uint8_t itemCount = plc4c_utils_list_size(_message->cyc_service_item_db_read_type_items);
   for(int curItem = 0; curItem < itemCount; curItem++) {
      plc4c_list_element* curElement = plc4c_utils_list_get_value(_message->cyc_service_item_db_read_type_items, curItem);
      lengthInBits += plc4c_s7_read_write_sub_item_length_in_bits(plc4x_spi_context_create_array_context(ctx, itemCount, curItem), (plc4c_s7_read_write_sub_item*) curElement);
    }
  }

      break;
    }
  }

  return lengthInBits;
}

