/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import org.apache.openjpa.util.OpenJPAId;

public final class FloatId
extends OpenJPAId {
    private final float key;

    public FloatId(Class cls, Float key) {
        this(cls, key == null ? 0.0f : key.floatValue());
    }

    public FloatId(Class cls, String key) {
        this(cls, key == null ? 0.0f : Float.parseFloat(key));
    }

    public FloatId(Class cls, float key) {
        super(cls);
        this.key = key;
    }

    public FloatId(Class cls, float key, boolean subs) {
        super(cls, subs);
        this.key = key;
    }

    public float getId() {
        return this.key;
    }

    @Override
    public Object getIdObject() {
        return Float.valueOf(this.key);
    }

    @Override
    public String toString() {
        return Float.toString(this.key);
    }

    @Override
    protected int idHash() {
        return Float.floatToIntBits(this.key);
    }

    @Override
    protected boolean idEquals(OpenJPAId o) {
        return this.key == ((FloatId)o).key;
    }
}

