/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.AbstractKeyEntryResolver;
import org.apache.sshd.common.util.MapEntryUtils;

public abstract class AbstractPublicKeyEntryDecoder
extends AbstractKeyEntryResolver
implements PublicKeyEntryDecoder {
    protected AbstractPublicKeyEntryDecoder(Collection<String> names) {
        super(names);
    }

    protected final boolean parseBooleanHeader(Map<String, String> headers, String propertyKey, boolean defaultVal) {
        Boolean boolVal;
        if (MapEntryUtils.isEmpty(headers) || !headers.containsKey(propertyKey)) {
            return defaultVal;
        }
        String stringVal = headers.get(propertyKey);
        try {
            boolVal = PropertyResolverUtils.parseBoolean(stringVal);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Ignoring non-boolean property value for \"{}\": {}", (Object)propertyKey, (Object)stringVal);
            boolVal = null;
        }
        if (boolVal == null) {
            return defaultVal;
        }
        return boolVal;
    }
}

