/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractIndexAnalyzerProvider<T extends Analyzer>
extends AbstractIndexComponent
implements AnalyzerProvider<T> {
    private final String name;
    protected final Version version;

    public AbstractIndexAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, String name, Settings settings) {
        super(index, indexSettings);
        this.name = name;
        this.version = Analysis.parseAnalysisVersion(indexSettings, settings, this.logger);
    }

    public AbstractIndexAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, String prefixSettings, String name, Settings settings) {
        super(index, indexSettings, prefixSettings);
        this.name = name;
        this.version = Analysis.parseAnalysisVersion(indexSettings, settings, this.logger);
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final AnalyzerScope scope() {
        return AnalyzerScope.INDEX;
    }
}

