/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.compressor;

import java.io.IOException;

public abstract class PipeCompressor {
    private final PipeCompressionType compressionType;

    protected PipeCompressor(PipeCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public abstract byte[] compress(byte[] var1) throws IOException;

    public abstract byte[] decompress(byte[] var1) throws IOException;

    public abstract byte[] decompress(byte[] var1, int var2) throws IOException;

    public byte serialize() {
        return this.compressionType.getIndex();
    }

    public static enum PipeCompressionType {
        SNAPPY(0),
        GZIP(1),
        LZ4(2),
        ZSTD(3),
        LZMA2(4);

        final byte index;

        private PipeCompressionType(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }
    }
}

