/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.subtask;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.pipe.PipeConsensusRetryWithIncreasingIntervalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeSinkRetryTimesConfigurableException;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeSubtask;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeReportableSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeReportableSubtask.class);
    protected final AtomicLong highPriorityLockTaskCount = new AtomicLong(0L);

    protected PipeReportableSubtask(String taskID, long creationTime) {
        super(taskID, creationTime);
    }

    public synchronized void onFailure(Throwable throwable) {
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe subtask, ignored because pipe is dropped.", throwable);
            this.clearReferenceCountAndReleaseLastEvent(null);
            return;
        }
        if (this.lastEvent instanceof EnrichedEvent) {
            this.onEnrichedEventFailure(throwable);
        } else {
            this.onNonEnrichedEventFailure(throwable);
        }
    }

    private long getSleepIntervalBasedOnThrowable(Throwable throwable) {
        long sleepInterval = Math.min(1000L * (long)this.retryCount.get(), 10000L);
        if (throwable instanceof PipeConsensusRetryWithIncreasingIntervalException) {
            sleepInterval = this.retryCount.get() >= 5 ? 20000L : 1000L * (long)this.retryCount.get() * (long)this.retryCount.get();
        }
        return sleepInterval;
    }

    private void onEnrichedEventFailure(Throwable throwable) {
        int maxRetryTimes;
        int n = maxRetryTimes = throwable instanceof PipeRuntimeSinkRetryTimesConfigurableException ? ((PipeRuntimeSinkRetryTimesConfigurableException)((Object)throwable)).getRetryTimes() : 5;
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry for {} times.", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable.getMessage(), maxRetryTimes, throwable});
        }
        this.retryCount.incrementAndGet();
        if (this.retryCount.get() <= maxRetryTimes) {
            LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count [{}/{}], last exception: {}", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get(), maxRetryTimes, throwable.getMessage(), throwable});
            try {
                this.sleepIfNoHighPriorityTask(this.getSleepIntervalBasedOnThrowable(throwable));
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), e});
                Thread.currentThread().interrupt();
            }
            this.submitSelf();
        } else {
            String errorMessage = String.format("Failed to execute subtask %s (creation time: %s, simple class: %s), retry count exceeds the max retry times %d, last exception: %s, root cause: %s", this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get() - 1, throwable.getMessage(), this.getRootCause(throwable));
            LOGGER.warn(errorMessage, throwable);
            this.report((EnrichedEvent)this.lastEvent, throwable instanceof PipeRuntimeException ? (PipeRuntimeException)((Object)throwable) : new PipeRuntimeCriticalException(errorMessage));
            LOGGER.warn("The last event is an instance of EnrichedEvent, so the exception is reported. Stopping current pipe subtask {} (creation time: {}, simple class: {}) locally... Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable});
        }
    }

    protected abstract String getRootCause(Throwable var1);

    protected abstract void report(EnrichedEvent var1, PipeRuntimeException var2);

    private void onNonEnrichedEventFailure(Throwable throwable) {
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {} (creation time: {}, simple class: {}), because of {}. Will retry forever.", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable.getMessage(), throwable});
        }
        this.retryCount.incrementAndGet();
        LOGGER.warn("Retry executing subtask {} (creation time: {}, simple class: {}), retry count {}, last exception: {}", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName(), this.retryCount.get(), throwable.getMessage(), throwable});
        try {
            this.sleepIfNoHighPriorityTask(this.getSleepIntervalBasedOnThrowable(throwable));
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when retrying to execute subtask {} (creation time: {}, simple class: {})", new Object[]{this.taskID, this.creationTime, this.getClass().getSimpleName()});
            Thread.currentThread().interrupt();
        }
        this.submitSelf();
    }

    protected void preScheduleLowPriorityTask(int maxRetries) {
        while (this.highPriorityLockTaskCount.get() != 0L && maxRetries-- > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupted while waiting for the high priority lock task.", (Throwable)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleepIfNoHighPriorityTask(long sleepMillis) throws InterruptedException {
        AtomicLong atomicLong = this.highPriorityLockTaskCount;
        synchronized (atomicLong) {
            if (this.highPriorityLockTaskCount.get() > 0L) {
                this.highPriorityLockTaskCount.wait(sleepMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseHighPriorityTaskCount() {
        this.highPriorityLockTaskCount.incrementAndGet();
        AtomicLong atomicLong = this.highPriorityLockTaskCount;
        synchronized (atomicLong) {
            this.highPriorityLockTaskCount.notifyAll();
        }
    }

    public void decreaseHighPriorityTaskCount() {
        this.highPriorityLockTaskCount.decrementAndGet();
    }
}

