/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.tsfile.utils.Pair;

public class PredicateUtils {
    private PredicateUtils() {
    }

    public static Pair<Expression, Boolean> extractGlobalTimePredicate(Expression predicate, boolean canRewrite, boolean isFirstOr) {
        if (predicate instanceof LogicalExpression && ((LogicalExpression)predicate).getOperator().equals((Object)LogicalExpression.Operator.AND)) {
            Pair<Expression, Boolean> leftResultPair = PredicateUtils.extractGlobalTimePredicate(((LogicalExpression)predicate).getTerms().get(0), canRewrite, isFirstOr);
            Pair<Expression, Boolean> rightResultPair = PredicateUtils.extractGlobalTimePredicate(((LogicalExpression)predicate).getTerms().get(1), canRewrite, isFirstOr);
            if (canRewrite) {
                LogicalExpression logicalExpression = (LogicalExpression)predicate;
                BooleanLiteral newLeftExpression = null;
                BooleanLiteral newRightExpression = null;
                if (leftResultPair.left != null && !((Boolean)leftResultPair.right).booleanValue()) {
                    newLeftExpression = BooleanLiteral.TRUE_LITERAL;
                }
                if (rightResultPair.left != null && !((Boolean)rightResultPair.right).booleanValue()) {
                    newRightExpression = BooleanLiteral.TRUE_LITERAL;
                }
                if (newLeftExpression != null || newRightExpression != null) {
                    logicalExpression.setTerms(Arrays.asList(newLeftExpression != null ? newLeftExpression : logicalExpression.getTerms().get(0), newRightExpression != null ? newRightExpression : logicalExpression.getTerms().get(1)));
                }
            }
            if (leftResultPair.left != null && rightResultPair.left != null) {
                return new Pair((Object)LogicalExpression.and((Expression)leftResultPair.left, (Expression)rightResultPair.left), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            if (leftResultPair.left != null) {
                return new Pair((Object)((Expression)leftResultPair.left), (Object)true);
            }
            if (rightResultPair.left != null) {
                return new Pair((Object)((Expression)rightResultPair.left), (Object)true);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof LogicalExpression && ((LogicalExpression)predicate).getOperator().equals((Object)LogicalExpression.Operator.OR)) {
            Pair<Expression, Boolean> leftResultPair = PredicateUtils.extractGlobalTimePredicate(((LogicalExpression)predicate).getTerms().get(0), false, false);
            Pair<Expression, Boolean> rightResultPair = PredicateUtils.extractGlobalTimePredicate(((LogicalExpression)predicate).getTerms().get(1), false, false);
            if (leftResultPair.left != null && rightResultPair.left != null) {
                if (Boolean.TRUE.equals(isFirstOr && (Boolean)leftResultPair.right == false && (Boolean)rightResultPair.right == false)) {
                    ((LogicalExpression)predicate).getTerms().set(0, BooleanLiteral.TRUE_LITERAL);
                    ((LogicalExpression)predicate).getTerms().set(0, BooleanLiteral.TRUE_LITERAL);
                }
                return new Pair((Object)LogicalExpression.or((Expression)leftResultPair.left, (Expression)rightResultPair.left), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof ComparisonExpression) {
            Expression rightExpression;
            Expression leftExpression = ((ComparisonExpression)predicate).getLeft();
            if (PredicateUtils.checkIsTimeFilter(leftExpression, rightExpression = ((ComparisonExpression)predicate).getRight()) || PredicateUtils.checkIsTimeFilter(rightExpression, leftExpression)) {
                return new Pair((Object)predicate, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof InPredicate) {
            return new Pair(null, (Object)true);
        }
        throw new IllegalStateException("Unsupported expression in extractGlobalTimePredicate: " + predicate);
    }

    private static boolean checkIsTimeFilter(Expression timeExpression, Expression valueExpression) {
        return timeExpression instanceof Identifier && ((Identifier)timeExpression).getValue().equalsIgnoreCase("time") && valueExpression instanceof LongLiteral;
    }
}

