/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.IntLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LogicLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;
import pl.edu.icm.jlargearrays.ObjectLargeArray;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.StringLargeArray;
import pl.edu.icm.jlargearrays.UnsignedByteLargeArray;
import sun.misc.Unsafe;

public class LargeArrayUtils {
    public static final Unsafe UNSAFE;

    private LargeArrayUtils() {
    }

    public static void arraycopy(LargeArray src, long srcPos, LargeArray dest, long destPos, long length) {
        if (src.getType() != dest.getType()) {
            throw new IllegalArgumentException("The type of source array is different than the type of destimation array.");
        }
        switch (src.getType()) {
            case LOGIC: {
                LargeArrayUtils.arraycopy((LogicLargeArray)src, srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                LargeArrayUtils.arraycopy((UnsignedByteLargeArray)src, srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                LargeArrayUtils.arraycopy((ShortLargeArray)src, srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                LargeArrayUtils.arraycopy((IntLargeArray)src, srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                LargeArrayUtils.arraycopy((LongLargeArray)src, srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                LargeArrayUtils.arraycopy((FloatLargeArray)src, srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                LargeArrayUtils.arraycopy((DoubleLargeArray)src, srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                LargeArrayUtils.arraycopy((ComplexFloatLargeArray)src, srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                LargeArrayUtils.arraycopy((ComplexDoubleLargeArray)src, srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                LargeArrayUtils.arraycopy((StringLargeArray)src, srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                LargeArrayUtils.arraycopy((ObjectLargeArray)src, srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(Object src, long srcPos, LargeArray dest, long destPos, long length) {
        switch (dest.getType()) {
            case LOGIC: {
                LargeArrayUtils.arraycopy((boolean[])src, (int)srcPos, (LogicLargeArray)dest, destPos, length);
                break;
            }
            case BYTE: {
                LargeArrayUtils.arraycopy((byte[])src, (int)srcPos, (ByteLargeArray)dest, destPos, length);
                break;
            }
            case UNSIGNED_BYTE: {
                Class<?> dataClass = src.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass == Byte.TYPE) {
                    LargeArrayUtils.arraycopy((byte[])src, (int)srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                    break;
                }
                LargeArrayUtils.arraycopy((short[])src, (int)srcPos, (UnsignedByteLargeArray)dest, destPos, length);
                break;
            }
            case SHORT: {
                LargeArrayUtils.arraycopy((short[])src, (int)srcPos, (ShortLargeArray)dest, destPos, length);
                break;
            }
            case INT: {
                LargeArrayUtils.arraycopy((int[])src, (int)srcPos, (IntLargeArray)dest, destPos, length);
                break;
            }
            case LONG: {
                LargeArrayUtils.arraycopy((long[])src, (int)srcPos, (LongLargeArray)dest, destPos, length);
                break;
            }
            case FLOAT: {
                LargeArrayUtils.arraycopy((float[])src, (int)srcPos, (FloatLargeArray)dest, destPos, length);
                break;
            }
            case DOUBLE: {
                LargeArrayUtils.arraycopy((double[])src, (int)srcPos, (DoubleLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_FLOAT: {
                LargeArrayUtils.arraycopy((float[])src, (int)srcPos, (ComplexFloatLargeArray)dest, destPos, length);
                break;
            }
            case COMPLEX_DOUBLE: {
                LargeArrayUtils.arraycopy((double[])src, (int)srcPos, (ComplexDoubleLargeArray)dest, destPos, length);
                break;
            }
            case STRING: {
                LargeArrayUtils.arraycopy((String[])src, (int)srcPos, (StringLargeArray)dest, destPos, length);
                break;
            }
            case OBJECT: {
                LargeArrayUtils.arraycopy((Object[])src, (int)srcPos, (ObjectLargeArray)dest, destPos, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
    }

    public static void arraycopy(final LogicLargeArray src, final long srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final boolean[] src, final int srcPos, final LogicLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setBoolean(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setBoolean(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setBoolean(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setBoolean(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ByteLargeArray src, final long srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final byte[] src, final int srcPos, final ByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final UnsignedByteLargeArray src, final long srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setByte(j, src.getByte(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src.getByte(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setByte(j, src.getByte(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final byte[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setByte(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setByte(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final short[] src, final int srcPos, final UnsignedByteLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setUnsignedByte(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setUnsignedByte(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setUnsignedByte(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setUnsignedByte(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ShortLargeArray src, final long srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setShort(j, src.getShort(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src.getShort(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setShort(j, src.getShort(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setShort(j, src.getShort(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final short[] src, final int srcPos, final ShortLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setShort(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setShort(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setShort(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setShort(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final IntLargeArray src, final long srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setInt(j, src.getInt(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src.getInt(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setInt(j, src.getInt(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setInt(j, src.getInt(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final int[] src, final int srcPos, final IntLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setInt(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setInt(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setInt(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setInt(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final LongLargeArray src, final long srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setLong(j, src.getLong(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src.getLong(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setLong(j, src.getLong(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setLong(j, src.getLong(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final long[] src, final int srcPos, final LongLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setLong(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setLong(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setLong(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setLong(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final FloatLargeArray src, final long srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setFloat(j, src.getFloat(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src.getFloat(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setFloat(j, src.getFloat(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setFloat(j, src.getFloat(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final FloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setFloat(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setFloat(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setFloat(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setFloat(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final DoubleLargeArray src, final long srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setDouble(j, src.getDouble(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src.getDouble(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setDouble(j, src.getDouble(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setDouble(j, src.getDouble(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final DoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.setDouble(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setDouble(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setDouble(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.setDouble(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ComplexFloatLargeArray src, final long srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexFloat(j, src.getComplexFloat(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexFloat(destPos + k, src.getComplexFloat(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexFloat(j, src.getComplexFloat(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexFloat(j, src.getComplexFloat(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final float[] src, final int srcPos, final ComplexFloatLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            float[] elem = new float[2];
            for (long j = destPos; j < destPos + length; ++j) {
                elem[0] = src[2 * i];
                elem[1] = src[2 * i + 1];
                dest.setComplexFloat(j, elem);
                ++i;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[2 * (srcPos + (int)k)];
                            elem[1] = src[2 * (srcPos + (int)k) + 1];
                            dest.setComplexFloat(destPos + k, elem);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                float[] elem = new float[2];
                for (long j = destPos; j < destPos + length; ++j) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexFloat(j, elem);
                    ++i;
                }
            }
            catch (ExecutionException ex) {
                float[] elem = new float[2];
                for (long j = destPos; j < destPos + length; ++j) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexFloat(j, elem);
                    ++i;
                }
            }
        }
    }

    public static void arraycopy(final ComplexDoubleLargeArray src, final long srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.setComplexDouble(j, src.getComplexDouble(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.setComplexDouble(destPos + k, src.getComplexDouble(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexDouble(j, src.getComplexDouble(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.setComplexDouble(j, src.getComplexDouble(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final double[] src, final int srcPos, final ComplexDoubleLargeArray dest, final long destPos, long length) {
        if (src.length % 2 != 0) {
            throw new IllegalArgumentException("The length of the source array must be even.");
        }
        if (srcPos < 0 || srcPos >= src.length / 2) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length / 2");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            double[] elem = new double[2];
            for (long j = destPos; j < destPos + length; ++j) {
                elem[0] = src[2 * i];
                elem[1] = src[2 * i + 1];
                dest.setComplexDouble(j, elem);
                ++i;
            }
        } else {
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            elem[0] = src[2 * (srcPos + (int)k)];
                            elem[1] = src[2 * (srcPos + (int)k) + 1];
                            dest.setComplexDouble(destPos + k, elem);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                double[] elem = new double[2];
                for (long j = destPos; j < destPos + length; ++j) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexDouble(j, elem);
                    ++i;
                }
            }
            catch (ExecutionException ex) {
                double[] elem = new double[2];
                for (long j = destPos; j < destPos + length; ++j) {
                    elem[0] = src[2 * i];
                    elem[1] = src[2 * i + 1];
                    dest.setComplexDouble(j, elem);
                    ++i;
                }
            }
        }
    }

    public static void arraycopy(final StringLargeArray src, final long srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final String[] src, final int srcPos, final StringLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
        }
    }

    public static void arraycopy(final ObjectLargeArray src, final long srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0L || srcPos >= src.length()) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length()");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            long i = srcPos;
            long j = destPos;
            while (i < srcPos + length) {
                dest.set(j, src.get(i));
                ++i;
                ++j;
            }
        } else {
            long j;
            long i;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src.get(srcPos + k));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                i = srcPos;
                j = destPos;
                while (i < srcPos + length) {
                    dest.set(j, src.get(i));
                    ++i;
                    ++j;
                }
            }
        }
    }

    public static void arraycopy(final Object[] src, final int srcPos, final ObjectLargeArray dest, final long destPos, long length) {
        if (srcPos < 0 || srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("srcPos < 0 || srcPos >= src.length");
        }
        if (destPos < 0L || destPos >= dest.length()) {
            throw new ArrayIndexOutOfBoundsException("destPos < 0 || destPos >= dest.length()");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        if (dest.isConstant()) {
            throw new IllegalArgumentException("Constant arrays cannot be modified.");
        }
        int i = srcPos;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long j = destPos; j < destPos + length; ++j) {
                dest.set(j, src[i++]);
            }
        } else {
            long j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            dest.set(destPos + k, src[srcPos + (int)k]);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
            catch (ExecutionException ex) {
                for (j = destPos; j < destPos + length; ++j) {
                    dest.set(j, src[i++]);
                }
            }
        }
    }

    public static LargeArray createConstant(LargeArrayType type, long length, Object value) {
        switch (type) {
            case LOGIC: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LogicLargeArray(length, v);
            }
            case BYTE: {
                byte v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (byte)1 : 0;
                } else if (value instanceof Byte) {
                    v = (Byte)value;
                } else if (value instanceof Short) {
                    v = ((Short)value).byteValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).byteValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).byteValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).byteValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).byteValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ByteLargeArray(length, v);
            }
            case UNSIGNED_BYTE: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new UnsignedByteLargeArray(length, v);
            }
            case SHORT: {
                short v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? (short)1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).shortValue();
                } else if (value instanceof Short) {
                    v = (Short)value;
                } else if (value instanceof Integer) {
                    v = ((Integer)value).shortValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).shortValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).shortValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).shortValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new ShortLargeArray(length, v);
            }
            case INT: {
                int v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1 : 0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).intValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).intValue();
                } else if (value instanceof Integer) {
                    v = (Integer)value;
                } else if (value instanceof Long) {
                    v = ((Long)value).intValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).intValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).intValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new IntLargeArray(length, v);
            }
            case LONG: {
                long v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1L : 0L;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).longValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).longValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).longValue();
                } else if (value instanceof Long) {
                    v = (Long)value;
                } else if (value instanceof Float) {
                    v = ((Float)value).longValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).longValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new LongLargeArray(length, v);
            }
            case FLOAT: {
                float v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0f : 0.0f;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).floatValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).floatValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).floatValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).floatValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).floatValue();
                } else if (value instanceof Double) {
                    v = ((Double)value).floatValue();
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new FloatLargeArray(length, v);
            }
            case DOUBLE: {
                double v;
                if (value instanceof Boolean) {
                    v = (Boolean)value == true ? 1.0 : 0.0;
                } else if (value instanceof Byte) {
                    v = ((Byte)value).doubleValue();
                } else if (value instanceof Short) {
                    v = ((Short)value).doubleValue();
                } else if (value instanceof Integer) {
                    v = ((Integer)value).doubleValue();
                } else if (value instanceof Long) {
                    v = ((Long)value).doubleValue();
                } else if (value instanceof Float) {
                    v = ((Float)value).doubleValue();
                } else if (value instanceof Double) {
                    v = (Double)value;
                } else {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                return new DoubleLargeArray(length, v);
            }
            case COMPLEX_FLOAT: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Float.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                float[] v = (float[])value;
                return new ComplexFloatLargeArray(length, v);
            }
            case COMPLEX_DOUBLE: {
                Class<?> dataClass = value.getClass();
                Class<?> componentClass = dataClass.getComponentType();
                if (componentClass != Double.TYPE) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                double[] v = (double[])value;
                return new ComplexDoubleLargeArray(length, v);
            }
            case STRING: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Invalid value type.");
                }
                String v = (String)value;
                return new StringLargeArray(length, v);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, value);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray create(LargeArrayType type, long length) {
        return LargeArrayUtils.create(type, length, true);
    }

    public static LargeArray create(LargeArrayType type, long length, boolean zeroNativeMemory) {
        switch (type) {
            case LOGIC: {
                return new LogicLargeArray(length, zeroNativeMemory);
            }
            case BYTE: {
                return new ByteLargeArray(length, zeroNativeMemory);
            }
            case UNSIGNED_BYTE: {
                return new UnsignedByteLargeArray(length, zeroNativeMemory);
            }
            case SHORT: {
                return new ShortLargeArray(length, zeroNativeMemory);
            }
            case INT: {
                return new IntLargeArray(length, zeroNativeMemory);
            }
            case LONG: {
                return new LongLargeArray(length, zeroNativeMemory);
            }
            case FLOAT: {
                return new FloatLargeArray(length, zeroNativeMemory);
            }
            case DOUBLE: {
                return new DoubleLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_FLOAT: {
                return new ComplexFloatLargeArray(length, zeroNativeMemory);
            }
            case COMPLEX_DOUBLE: {
                return new ComplexDoubleLargeArray(length, zeroNativeMemory);
            }
            case STRING: {
                return new StringLargeArray(length, 100, zeroNativeMemory);
            }
            case OBJECT: {
                return new ObjectLargeArray(length, 100, zeroNativeMemory);
            }
        }
        throw new IllegalArgumentException("Invalid array type.");
    }

    public static LargeArray generateRandom(LargeArrayType type, long length) {
        LargeArray res = LargeArrayUtils.create(type, length, false);
        Random rand = new Random();
        switch (type) {
            case LOGIC: {
                for (long i = 0L; i < length; ++i) {
                    res.setBoolean(i, rand.nextBoolean());
                }
                break;
            }
            case BYTE: 
            case UNSIGNED_BYTE: {
                int r;
                long i;
                for (i = 0L; i < length / 4L; i += 4L) {
                    r = rand.nextInt();
                    res.setByte(i, (byte)(r >>= 8));
                    res.setByte(i + 1L, (byte)(r >>= 8));
                    res.setByte(i + 2L, (byte)(r >>= 8));
                    res.setByte(i + 3L, (byte)(r >>= 8));
                }
                r = rand.nextInt();
                while (i < length) {
                    res.setByte(i, (byte)(r >>= 8));
                    ++i;
                }
                break;
            }
            case SHORT: {
                int r;
                long i;
                for (i = 0L; i < length / 2L; i += 2L) {
                    r = rand.nextInt();
                    res.setShort(i, (short)(r >>= 16));
                    res.setShort(i + 1L, (short)(r >>= 16));
                }
                r = rand.nextInt();
                while (i < length) {
                    res.setShort(i, (short)(r >>= 16));
                    ++i;
                }
                break;
            }
            case INT: {
                for (long i = 0L; i < length; ++i) {
                    res.setInt(i, rand.nextInt());
                }
                break;
            }
            case LONG: {
                for (long i = 0L; i < length; ++i) {
                    res.setLong(i, rand.nextLong());
                }
                break;
            }
            case FLOAT: {
                for (long i = 0L; i < length; ++i) {
                    res.setFloat(i, rand.nextFloat());
                }
                break;
            }
            case DOUBLE: {
                for (long i = 0L; i < length; ++i) {
                    res.setDouble(i, rand.nextDouble());
                }
                break;
            }
            case COMPLEX_FLOAT: {
                ComplexFloatLargeArray res_c = (ComplexFloatLargeArray)res;
                float[] elem_res = new float[2];
                for (long i = 0L; i < length; ++i) {
                    elem_res[0] = rand.nextFloat();
                    elem_res[1] = rand.nextFloat();
                    res_c.setComplexFloat(i, elem_res);
                }
                break;
            }
            case COMPLEX_DOUBLE: {
                ComplexDoubleLargeArray res_c = (ComplexDoubleLargeArray)res;
                double[] elem_res = new double[2];
                for (long i = 0L; i < length; ++i) {
                    elem_res[0] = rand.nextDouble();
                    elem_res[1] = rand.nextDouble();
                    res_c.setComplexDouble(i, elem_res);
                }
                break;
            }
            case STRING: {
                for (long i = 0L; i < length; ++i) {
                    res.setFloat(i, rand.nextFloat());
                }
                break;
            }
            case OBJECT: {
                for (long i = 0L; i < length; ++i) {
                    res.set(i, Float.valueOf(rand.nextFloat()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid array type.");
            }
        }
        return res;
    }

    public static LargeArray convert(final LargeArray src, final LargeArrayType type) {
        LargeArray out;
        block111: {
            long i;
            int nthreads;
            long length;
            block110: {
                if (src.getType() == type) {
                    return src;
                }
                if (src.isConstant()) {
                    switch (type) {
                        case LOGIC: {
                            return new LogicLargeArray(src.length(), src.getByte(0L));
                        }
                        case BYTE: {
                            return new ByteLargeArray(src.length(), src.getByte(0L));
                        }
                        case UNSIGNED_BYTE: {
                            return new UnsignedByteLargeArray(src.length(), src.getUnsignedByte(0L));
                        }
                        case SHORT: {
                            return new ShortLargeArray(src.length(), src.getShort(0L));
                        }
                        case INT: {
                            return new IntLargeArray(src.length(), src.getInt(0L));
                        }
                        case LONG: {
                            return new LongLargeArray(src.length(), src.getLong(0L));
                        }
                        case FLOAT: {
                            return new FloatLargeArray(src.length(), src.getFloat(0L));
                        }
                        case DOUBLE: {
                            return new DoubleLargeArray(src.length(), src.getDouble(0L));
                        }
                        case COMPLEX_FLOAT: {
                            return new ComplexFloatLargeArray(src.length(), ((ComplexFloatLargeArray)src).getComplexFloat(0L));
                        }
                        case COMPLEX_DOUBLE: {
                            return new ComplexDoubleLargeArray(src.length(), ((ComplexDoubleLargeArray)src).getComplexDouble(0L));
                        }
                        case STRING: {
                            return new StringLargeArray(src.length(), src.get(0L).toString());
                        }
                        case OBJECT: {
                            return new ObjectLargeArray(src.length(), src.get(0L));
                        }
                    }
                    throw new IllegalArgumentException("Invalid array type.");
                }
                length = src.length;
                out = LargeArrayUtils.create(type, length, false);
                nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
                if (nthreads >= 2 && length >= ConcurrencyUtils.getConcurrentThreshold()) break block110;
                switch (type) {
                    case LOGIC: 
                    case BYTE: {
                        for (long i2 = 0L; i2 < length; ++i2) {
                            out.setByte(i2, src.getByte(i2));
                        }
                        break block111;
                    }
                    case UNSIGNED_BYTE: {
                        for (long i3 = 0L; i3 < length; ++i3) {
                            out.setUnsignedByte(i3, src.getUnsignedByte(i3));
                        }
                        break block111;
                    }
                    case SHORT: {
                        for (long i4 = 0L; i4 < length; ++i4) {
                            out.setShort(i4, src.getShort(i4));
                        }
                        break block111;
                    }
                    case INT: {
                        for (long i5 = 0L; i5 < length; ++i5) {
                            out.setInt(i5, src.getInt(i5));
                        }
                        break block111;
                    }
                    case LONG: {
                        for (long i6 = 0L; i6 < length; ++i6) {
                            out.setLong(i6, src.getLong(i6));
                        }
                        break block111;
                    }
                    case FLOAT: {
                        for (long i7 = 0L; i7 < length; ++i7) {
                            out.setFloat(i7, src.getFloat(i7));
                        }
                        break block111;
                    }
                    case DOUBLE: {
                        for (long i8 = 0L; i8 < length; ++i8) {
                            out.setDouble(i8, src.getDouble(i8));
                        }
                        break block111;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (long i9 = 0L; i9 < length; ++i9) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i9, ((ComplexDoubleLargeArray)src).getComplexDouble(i9));
                            }
                        } else {
                            for (long i10 = 0L; i10 < length; ++i10) {
                                out.setFloat(i10, src.getFloat(i10));
                            }
                        }
                        break block111;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (long i11 = 0L; i11 < length; ++i11) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i11, ((ComplexFloatLargeArray)src).getComplexFloat(i11));
                            }
                        } else {
                            for (long i12 = 0L; i12 < length; ++i12) {
                                out.setDouble(i12, src.getDouble(i12));
                            }
                        }
                        break block111;
                    }
                    case STRING: {
                        for (long i13 = 0L; i13 < length; ++i13) {
                            out.set(i13, src.get(i13).toString());
                        }
                        break block111;
                    }
                    case OBJECT: {
                        for (long i14 = 0L; i14 < length; ++i14) {
                            out.set(i14, src.get(i14));
                        }
                        break block111;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        switch (type) {
                            case BYTE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setByte(i, src.getByte(i));
                                }
                                break;
                            }
                            case UNSIGNED_BYTE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setUnsignedByte(i, src.getUnsignedByte(i));
                                }
                                break;
                            }
                            case SHORT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setShort(i, src.getShort(i));
                                }
                                break;
                            }
                            case INT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setInt(i, src.getInt(i));
                                }
                                break;
                            }
                            case LONG: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setLong(i, src.getLong(i));
                                }
                                break;
                            }
                            case FLOAT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setFloat(i, src.getFloat(i));
                                }
                                break;
                            }
                            case DOUBLE: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.setDouble(i, src.getDouble(i));
                                }
                                break;
                            }
                            case COMPLEX_FLOAT: {
                                if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setFloat(i, src.getFloat(i));
                                    }
                                }
                                break;
                            }
                            case COMPLEX_DOUBLE: {
                                if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                                    }
                                } else {
                                    for (long i = firstIdx; i < lastIdx; ++i) {
                                        out.setDouble(i, src.getDouble(i));
                                    }
                                }
                                break;
                            }
                            case STRING: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i).toString());
                                }
                                break;
                            }
                            case OBJECT: {
                                for (long i = firstIdx; i < lastIdx; ++i) {
                                    out.set(i, src.get(i));
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid array type.");
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException ex) {
                switch (type) {
                    case LOGIC: 
                    case BYTE: {
                        for (i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                    }
                    case UNSIGNED_BYTE: {
                        for (i = 0L; i < length; ++i) {
                            out.setUnsignedByte(i, src.getUnsignedByte(i));
                        }
                    }
                    case SHORT: {
                        for (i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                    }
                    case INT: {
                        for (i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                    }
                    case LONG: {
                        for (i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                    }
                    case FLOAT: {
                        for (i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                    }
                    case DOUBLE: {
                        for (i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                    }
                    case STRING: {
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                    }
                    case OBJECT: {
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
            catch (ExecutionException ex) {
                switch (type) {
                    case LOGIC: 
                    case BYTE: {
                        for (i = 0L; i < length; ++i) {
                            out.setByte(i, src.getByte(i));
                        }
                        break;
                    }
                    case UNSIGNED_BYTE: {
                        for (i = 0L; i < length; ++i) {
                            out.setUnsignedByte(i, src.getUnsignedByte(i));
                        }
                        break;
                    }
                    case SHORT: {
                        for (i = 0L; i < length; ++i) {
                            out.setShort(i, src.getShort(i));
                        }
                        break;
                    }
                    case INT: {
                        for (i = 0L; i < length; ++i) {
                            out.setInt(i, src.getInt(i));
                        }
                        break;
                    }
                    case LONG: {
                        for (i = 0L; i < length; ++i) {
                            out.setLong(i, src.getLong(i));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (i = 0L; i < length; ++i) {
                            out.setFloat(i, src.getFloat(i));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (i = 0L; i < length; ++i) {
                            out.setDouble(i, src.getDouble(i));
                        }
                        break;
                    }
                    case COMPLEX_FLOAT: {
                        if (src.getType() == LargeArrayType.COMPLEX_DOUBLE) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexFloatLargeArray)out).setComplexDouble(i, ((ComplexDoubleLargeArray)src).getComplexDouble(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setFloat(i, src.getFloat(i));
                            }
                        }
                        break;
                    }
                    case COMPLEX_DOUBLE: {
                        if (src.getType() == LargeArrayType.COMPLEX_FLOAT) {
                            for (i = 0L; i < length; ++i) {
                                ((ComplexDoubleLargeArray)out).setComplexFloat(i, ((ComplexFloatLargeArray)src).getComplexFloat(i));
                            }
                        } else {
                            for (i = 0L; i < length; ++i) {
                                out.setDouble(i, src.getDouble(i));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i).toString());
                        }
                        break;
                    }
                    case OBJECT: {
                        for (i = 0L; i < length; ++i) {
                            out.set(i, src.get(i));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid array type.");
                    }
                }
            }
        }
        return out;
    }

    public static LargeArray select(LargeArray src, final LogicLargeArray mask) {
        long j;
        int j2;
        if (src.length != mask.length) {
            throw new IllegalArgumentException("src.length != mask.length");
        }
        long length = src.length;
        long count = 0L;
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        long k = length / (long)nthreads;
        ExecutorService pool = Executors.newCachedThreadPool();
        Future[] futures = new Future[nthreads];
        for (j2 = 0; j2 < nthreads; ++j2) {
            final long firstIdx = (long)j2 * k;
            final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k;
            futures[j2] = pool.submit(new Callable(){

                public Long call() {
                    long count = 0L;
                    for (long k = firstIdx; k < lastIdx; ++k) {
                        if (mask.getByte(k) != 1) continue;
                        ++count;
                    }
                    return count;
                }
            });
        }
        try {
            for (j2 = 0; j2 < nthreads; ++j2) {
                count += ((Long)futures[j2].get()).longValue();
            }
        }
        catch (Exception ex) {
            for (j = 0L; j < length; ++j) {
                if (mask.getByte(j) != 1) continue;
                ++count;
            }
        }
        if (count <= 0L) {
            return null;
        }
        LargeArray res = LargeArrayUtils.create(src.getType(), count, false);
        k = 0L;
        for (j = 0L; j < length; ++j) {
            if (mask.getByte(j) != 1) continue;
            res.set(k++, src.get(j));
        }
        return res;
    }

    static {
        Object theUnsafe = null;
        Exception exception = null;
        try {
            Class<?> uc = Class.forName("sun.misc.Unsafe");
            Field f = uc.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = f.get(uc);
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        catch (NoSuchFieldException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        UNSAFE = (Unsafe)theUnsafe;
        if (UNSAFE == null) {
            throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
        }
    }
}

