/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTabletEventSorter {
    private final Tablet tablet;
    private boolean isSorted = true;
    private boolean isDeDuplicated = true;
    private Integer[] index;
    private int[] deDuplicatedIndex;
    private int deDuplicatedSize;

    public PipeTabletEventSorter(Tablet tablet) {
        this.tablet = tablet;
        this.deDuplicatedSize = tablet == null ? 0 : tablet.rowSize;
    }

    public void deduplicateAndSortTimestampsIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.rowSize == 0) {
            return;
        }
        int size = this.tablet.rowSize;
        for (i = 1; i < size; ++i) {
            long currentTimestamp = this.tablet.timestamps[i];
            long previousTimestamp = this.tablet.timestamps[i - 1];
            if (currentTimestamp < previousTimestamp) {
                this.isSorted = false;
            }
            if (currentTimestamp == previousTimestamp) {
                this.isDeDuplicated = false;
            }
            if (!this.isSorted && !this.isDeDuplicated) break;
        }
        if (this.isSorted && this.isDeDuplicated) {
            return;
        }
        this.index = new Integer[this.tablet.rowSize];
        this.deDuplicatedIndex = new int[this.tablet.rowSize];
        size = this.tablet.rowSize;
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (!this.isSorted) {
            this.sortTimestamps();
            this.deduplicateTimestamps();
            this.isDeDuplicated = true;
        }
        if (!this.isDeDuplicated) {
            this.deduplicateTimestamps();
        }
        this.sortAndMayDeduplicateValuesAndBitMaps();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(i -> this.tablet.timestamps[i]));
        Arrays.sort(this.tablet.timestamps, 0, this.tablet.rowSize);
    }

    private void deduplicateTimestamps() {
        this.deDuplicatedSize = 0;
        long[] timestamps = this.tablet.timestamps;
        int size = this.tablet.rowSize;
        for (int i = 1; i < size; ++i) {
            if (timestamps[i] == timestamps[i - 1]) continue;
            this.deDuplicatedIndex[this.deDuplicatedSize] = i - 1;
            timestamps[this.deDuplicatedSize] = timestamps[i - 1];
            ++this.deDuplicatedSize;
        }
        this.deDuplicatedIndex[this.deDuplicatedSize] = this.tablet.rowSize - 1;
        timestamps[this.deDuplicatedSize] = timestamps[this.tablet.rowSize - 1];
        this.tablet.rowSize = ++this.deDuplicatedSize;
    }

    private void sortAndMayDeduplicateValuesAndBitMaps() {
        int columnIndex = 0;
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            BitMap deDuplicatedBitMap = null;
            BitMap originalBitMap = null;
            if (this.tablet.bitMaps != null && this.tablet.bitMaps[columnIndex] != null) {
                originalBitMap = this.tablet.bitMaps[columnIndex];
                deDuplicatedBitMap = new BitMap(originalBitMap.getSize());
            }
            this.tablet.values[columnIndex] = this.reorderValueListAndBitMap(this.tablet.values[columnIndex], schema.getType(), originalBitMap, deDuplicatedBitMap);
            if (this.tablet.bitMaps != null && this.tablet.bitMaps[columnIndex] != null) {
                this.tablet.bitMaps[columnIndex] = deDuplicatedBitMap;
            }
            ++columnIndex;
        }
    }

    private Object reorderValueListAndBitMap(Object valueList, TSDataType dataType, BitMap originalBitMap, BitMap deDuplicatedBitMap) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] deDuplicatedBoolValues = new boolean[boolValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedBoolValues[i] = boolValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedBoolValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] deDuplicatedIntValues = new int[intValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedIntValues[i] = intValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedIntValues;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])valueList;
                LocalDate[] deDuplicatedDateValues = new LocalDate[dateValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedDateValues[i] = dateValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] deDuplicatedLongValues = new long[longValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedLongValues[i] = longValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] deDuplicatedFloatValues = new float[floatValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedFloatValues[i] = floatValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] deDuplicatedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedDoubleValues[i] = doubleValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] deDuplicatedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedBinaryValues[i] = binaryValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }

    private int getLastNonnullIndex(int i, BitMap originalBitMap, BitMap deDuplicatedBitMap) {
        int lastIndex;
        if (originalBitMap == null) {
            return this.index[this.deDuplicatedIndex[i]];
        }
        int lastNonnullIndex = this.deDuplicatedIndex[i];
        int n = lastIndex = i > 0 ? this.deDuplicatedIndex[i - 1] : -1;
        while (originalBitMap.isMarked(this.index[lastNonnullIndex].intValue())) {
            if (--lastNonnullIndex != lastIndex) continue;
            deDuplicatedBitMap.mark(i);
            return this.index[lastNonnullIndex + 1];
        }
        return this.index[lastNonnullIndex];
    }
}

